<?php
/**
 * @package    theme_edifi
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author    LMSACE Dev Team
 */

defined('MOODLE_INTERNAL') || die();

class theme_edifi_core_renderer extends theme_boost\output\core_renderer {

    public $centerMenu = array();

    public function navbar(): string {
        $items = $this->page->navbar->get_items();
        if (empty($items)) { // MDL-46107
            return '';
        }
        $breadcrumbs = '';
        foreach ($items as $item) {
            $item->hideicon = true;
            $breadcrumbs .= '<li>'.$this->render($item).'</li>';
        }
        return "<ol class=breadcrumb>$breadcrumbs</ol>";
    }

    /**
     * Construct a user menu, returning HTML that can be echoed out by a
     * layout file.
     *
     * @param stdClass $user A user object, usually $USER.
     * @param bool $withlinks true if a dropdown should be built.
     * @return string HTML fragment.
     */
    public function user_menu($user = null, $withlinks = null) {
        global $USER, $CFG;
        require_once($CFG->dirroot . '/user/lib.php');

        if (is_null($user)) {
            $user = $USER;
        }

        // Note: this behaviour is intended to match that of core_renderer::login_info,
        // but should not be considered to be good practice; layout options are
        // intended to be theme-specific. Please don't copy this snippet anywhere else.
        if (is_null($withlinks)) {
            $withlinks = empty($this->page->layout_options['nologinlinks']);
        }

        // Add a class for when $withlinks is false.
        $usermenuclasses = 'usermenu';
        if (!$withlinks) {
            $usermenuclasses .= ' withoutlinks';
        }

        $returnstr = "";

        // If during initial install, return the empty return string.
        if (during_initial_install()) {
            return $returnstr;
        }

        $loginpage = $this->is_login_page();
        $loginurl = get_login_url();
        // If not logged in, show the typical not-logged-in string.
        if (!isloggedin()) {
            $returnstr = ""; // get_string('loggedinnot', 'moodle');

            if (!$loginpage) {

                $returnstr .= " <a href=\"$loginurl\">" . get_string('login') . '</a>';
            }

            return html_writer::div(
                html_writer::span(
                    $returnstr,
                    'login'
                ),
                $usermenuclasses
            );

        }

        // If logged in as a guest user, show a string to that effect.
        if (isguestuser()) {
            $returnstr = "";// "Hi, Guest<br>";
            if (!$loginpage && $withlinks) {
                $returnstr .= "<a href=\"$loginurl\">".get_string('login');
            }
            $str = get_string('loggedinasguest');
            $returnstr .= "<span class='avatar' title='".$str."'> <span class='user-letter'> G </span></span>";
            if (!$loginpage && $withlinks) {
                $returnstr .= '</a> ';
            }
            return html_writer::div(
                html_writer::span(
                    $returnstr,
                    'login'
                ),
                $usermenuclasses
            );
        }
        // Get some navigation opts.
        $opts = user_get_user_navigation_info($user, $this->page);

        $avatarclasses = "avatars";
        if ($USER->picture == 0) {
            $username = $USER->username;
            $profile = html_writer::tag('span', ucfirst($username[0]) , array('class' => 'user-name loggedin-user user-letter') );
        } else {
            $profile = $opts->metadata['useravatar'];
        }
        $avatarcontents = html_writer::span($profile, 'avatar current');
        $usertextcontents = $opts->metadata['userfullname'];

        // Other user.
        if (!empty($opts->metadata['asotheruser'])) {
            $avatarcontents .= html_writer::span(
                $opts->metadata['realuseravatar'],
                'avatar realuser'
            );
            $usertextcontents = $opts->metadata['realuserfullname'];
            $usertextcontents .= html_writer::tag(
                'span',
                get_string(
                    'loggedinas',
                    'moodle',
                    html_writer::span(
                        $opts->metadata['userfullname'],
                        'value'
                    )
                ),
                array('class' => 'meta viewingas')
            );
        }

        // Role.
        if (!empty($opts->metadata['asotherrole'])) {
            $role = core_text::strtolower(preg_replace('#[ ]+#', '-', trim($opts->metadata['rolename'])));
            $usertextcontents .= html_writer::span(
                $opts->metadata['rolename'],
                'meta role role-' . $role
            );
        }

        // User login failures.
        if (!empty($opts->metadata['userloginfail'])) {
            $usertextcontents .= html_writer::span(
                $opts->metadata['userloginfail'],
                'meta loginfailures'
            );
        }

        // MNet.
        if (!empty($opts->metadata['asmnetuser'])) {
            $mnet = strtolower(preg_replace('#[ ]+#', '-', trim($opts->metadata['mnetidprovidername'])));
            $usertextcontents .= html_writer::span(
                $opts->metadata['mnetidprovidername'],
                'meta mnet mnet-' . $mnet
            );
        }

        $returnstr .= html_writer::span(
            html_writer::span($usertextcontents, 'usertext') .
            html_writer::span($avatarcontents, $avatarclasses),
            'userbutton'
        );

        // Create a divider (well, a filler).
        $divider = new action_menu_filler();
        $divider->primary = false;

        $am = new action_menu();
        $am->set_menu_trigger(
            $returnstr
        );
        $am->set_menu_left(action_menu::TR, action_menu::BR);
        $am->set_nowrap_on_items();
        if ($withlinks) {
            $navitemcount = count($opts->navitems);
            $idx = 0;
            foreach ($opts->navitems as $key => $value) {

                switch ($value->itemtype) {
                    case 'divider':
                        // If the nav item is a divider, add one and skip link processing.
                        $am->add($divider);
                        break;

                    case 'invalid':
                        // Silently skip invalid entries (should we post a notification?).
                        break;

                    case 'link':
                        // Process this as a link item.
                        $pix = null;
                        if (isset($value->pix) && !empty($value->pix)) {
                            $pix = new pix_icon($value->pix, $value->title, null, array('class' => 'iconsmall'));
                        } else if (isset($value->imgsrc) && !empty($value->imgsrc)) {
                            $value->title = html_writer::img(
                                $value->imgsrc,
                                $value->title,
                                array('class' => 'iconsmall')
                            ) . $value->title;
                        }

                        $al = new action_menu_link_secondary(
                            $value->url,
                            $pix,
                            $value->title,
                            array('class' => 'icon')
                        );
                        if (!empty($value->titleidentifier)) {
                            $al->attributes['data-title'] = $value->titleidentifier;
                        }
                        $am->add($al);
                        break;
                }

                $idx++;

                // Add dividers after the first item and before the last item.
                if ($idx == 1 || $idx == $navitemcount - 1) {
                    $am->add($divider);
                }
            }
        }

        return html_writer::div(
            $this->render($am),
            $usermenuclasses
        );
    }

    public function head_foot_left() {
        global $CFG;
        $url = new moodle_url("/course/index.php");
        $typo = theme_url().'/typo';

        $header_foot_left = '<ul class="nav navbar-nav">
                    <li><a href="'. $CFG->wwwroot.'"><i class="fa fa-home"></i>'.get_string("home").'</a></li>
                    <li><a href="'.$url.'">'. get_string("courses").'</a></li>
                    <li><a href="'.$typo.'">'.get_string('typography', 'theme_edifi').'</a></li>
                </ul>';
        return $header_foot_left;
    }

    /**
     *  Call the custom menu renderer function and returns the custom menu html contents
     * @param type|string $custommenuitems
     * @param type|string $methodValue
     * @return type
     */
    public function custom_menu($custommenuitems = '', $methodValue = "") {
        global $CFG;

        if (empty($custommenuitems) && !empty($CFG->custommenuitems)) {
            $custommenuitems = $CFG->custommenuitems;
        }
        $custommenu = new custom_menu($custommenuitems, current_language());
        return $this->render_custom_menu($custommenu, $methodValue);
    }

    /**
     * Renderer the custom menu templates with the values.
     * @param custom_menu $menu
     * @param type|string $methodValue
     * @return type
     */
    protected function render_custom_menu(custom_menu $menu, $methodValue="") {
        global $CFG;
        // print_r($menu);

        $langs = get_string_manager()->get_list_of_translations();
        $haslangmenu = $this->lang_menu() != '';

        if (!$menu->has_children() && !$haslangmenu) {
            return '';
        }

        if ($haslangmenu) {
            $strlang = get_string('language');
            $currentlang = current_language();
            if (isset($langs[$currentlang])) {
                $currentlang = $langs[$currentlang];
            } else {
                $currentlang = $strlang;
            }
            $this->language = $menu->add($currentlang, new moodle_url('#'), $strlang, 10000);
            foreach ($langs as $langtype => $langname) {
                $this->language->add($langname, new moodle_url($this->page->url, array('lang' => $langtype)), $langname);
            }
        }

        $content = '';
        $splitContent1 = "";
        $splitContent2 = "";
        $count = count($menu->get_children());
        $splitLevel = ceil($count / 2);
        $i = 1;
        $mi = 1;

        $headerStyle = theme_edifi_header_style('CENTER');

        foreach ($menu->get_children() as $item) {
            $context = $item->export_for_template($this);
            $content .= $this->render_from_template('core/custom_menu_item', $context);
            if ($headerStyle && $methodValue == "CENTER") {
                if ($splitLevel >= $i) {
                    $centerMenu[1] = $content;
                    if ($splitLevel == $i) {
                        $content = "";
                    }
                } else {
                    $centerMenu[2] = $content;
                }
                $i++;
            }
        }
        if ($headerStyle && $methodValue == "CENTER") {
            $this->centerMenu = $centerMenu;
            return $this->centerMenu;
        } else {
            return $content;
        }
    }

    /**
     * Get the language menu
     * @return type
     */
    public function theme_edifi_lang_menu() {
         global $CFG;
        $menu = new custom_menu("", current_language());
        $langs = get_string_manager()->get_list_of_translations();
        $haslangmenu = $this->lang_menu() != '';

        if (!$menu->has_children() && !$haslangmenu) {
            return '';
        }

        if ($haslangmenu) {
            $strlang = get_string('language');
            $currentlang = current_language();
            if (isset($langs[$currentlang])) {
                $currentlang = $langs[$currentlang];
            } else {
                $currentlang = $strlang;
            }
            $this->language = $menu->add($currentlang, new moodle_url('#'), $strlang, 10000);
            foreach ($langs as $langtype => $langname) {
                $this->language->add($langname, new moodle_url($this->page->url, array('lang' => $langtype)), $langname);
            }
        }

        $content = '';
        foreach ($menu->get_children() as $item) {
            $context = $item->export_for_template($this);
            $content .= $this->render_from_template('core/custom_menu_item', $context);
        }

        return $content;
    }

    /**
     * Split the theme custom menu into two parts if it's needed.
     * @param type|string $methodValue
     * @return type
     */
    public function theme_edifi_center_menu($methodValue = "") {
        $headerStyle = theme_edifi_header_style('CENTER');
        if ($headerStyle) {
            if (!empty($methodValue)) {
                if ($methodValue == "1")
                    return (isset($this->centerMenu[$methodValue])) ? $this->centerMenu[$methodValue] : $this->centerMenu;
                else
                    return (isset($this->centerMenu[$methodValue])) ? $this->centerMenu[$methodValue] : "";

            } else {
                return $this->centerMenu;
            }
        }
    }

    /**
     * Render the login page template.
     * @param \core_auth\output\login $form
     * @return type
     */
    // public function render_login(\core_auth\output\login $form) {
    // global $CFG, $PAGE, $SITE, $OUTPUT;
    // $context = $form->export_for_template($this);
    // Override because rendering is not supported in template yet.
    // $context->cookieshelpiconformatted = $this->help_icon('cookiesenabled');
    // $context->errorformatted = $this->error_text($context->error);
    // $maincontent = $this->render_from_template('theme_edifi/loginform', $context);
    // return  $maincontent ;
    // }
}