<?php
function edifi_slide_get_video($data) {
    $slideContent  = "";
    $slideHeight = theme_edifi_get_setting('slideHeight'); // Slide Height from user settings.

    $slideHeight = intval($slideHeight);
    if ($data['videoType'] == "youtube" || $data['videoType'] == "VIMEO") {
        $vstyle = "width:100%;float: none; clear: both; margin: 2px auto";

        /*$slideContent .= html_writer::tag('div', '', array('class' => 'youtube-player player', 'id' => 'youtubePlayer_'.$data['i'], 'data-property' => "{videoURL:'".$data['slideVideo']."', containment:'#youtubePlayer_".$data['i']."', showControls:false, autoplay:true, loop:true, vol:50, startAt:0, opacity:1, addRaster:true, quality:'large', optimizeDisplay:true, gaTrack:false, mask:'".$data['slideimg']."' }", 'data-mask' => $data['slideimg'] ));*/

        $slideContent .= html_writer::tag('iframe', '', ['class' => 'youtube-player', 'id' => 'youtubePlayer'.$data['i'], 'src' => $data['slideVideo'], 'allowfullscreen' => 'true', 'webkit-fullscreen' => 'true' ]);

    } else {
        $volume = ($data['slidevolume'] == 1) ? "false" : 'true';
         $slideContent .= html_writer::start_tag('video', [ 'class' => 'browser-video', 'id' => 'video-bg', 'loop' => 'true','poster' => $data['slideposterimg'],'autoplay'=> "true",'muted' => 'true'] );
        $slideContent .= html_writer::empty_tag('source', ['src' => $data['slideVideo'], 'type' => 'video/mp4' ]);
        $slideContent .= html_writer::empty_tag('source', ['src' => $data['slideVideo'], 'type' => 'video/ogg' ]);
        $slideContent .= html_writer::empty_tag('source', ['src' => $data['slideVideo'], 'type' => 'video/webm']);
        $slideContent .= html_writer::end_tag('video');
    }
    return $slideContent;
}

function edifi_slide_get_settings($s1) {
    global $PAGE;
    $data = [];
    $data['i'] = $s1;
    $data['slideStatus'] = theme_edifi_get_setting('slide'.$s1.'status');
    $slideCaption = theme_edifi_get_setting('slide' . $s1 . 'caption', true);
    $data['slidecaption'] = theme_edifi_lang($slideCaption);
    $data['slideurl1'] = theme_edifi_get_setting('slide' . $s1 . 'url1');
    $slideurl1 = theme_edifi_get_setting('slide' . $s1 . 'urltext1');
    $data['slideurltext1'] = theme_edifi_lang($slideurl1);
    $data['slideurltarget1'] = theme_edifi_get_setting('slide'. $s1 . 'urltarget1');
    $data['slideurltarget2'] = theme_edifi_get_setting('slide'. $s1 . 'urltarget2');
    $data['slidezoom'] = theme_edifi_get_setting('slide'. $s1 .'imgZoom');
    $data['slideurl2'] = theme_edifi_get_setting('slide'. $s1 .'url2');
    $slideurl2 = theme_edifi_get_setting('slide'. $s1 .'urltext2');
    $data['slideurltext2'] = theme_edifi_lang($slideurl2);
    
    $data['slideurl3'] = theme_edifi_get_setting('slide'. $s1 .'url3');
    $slideurl3 = theme_edifi_get_setting('slide'. $s1 .'urltext3');
    $data['slideurltext3'] = theme_edifi_lang($slideurl3);
    
    $data['slideurl4'] = theme_edifi_get_setting('slide'. $s1 .'url4');
    $slideurl4 = theme_edifi_get_setting('slide'. $s1 .'urltext4');
    $data['slideurltext4'] = theme_edifi_lang($slideurl4);
    
    $data['slideurl5'] = theme_edifi_get_setting('slide'. $s1 .'url5');
    $slideurl5 = theme_edifi_get_setting('slide'. $s1 .'urltext5');
    $data['slideurltext5'] = theme_edifi_lang($slideurl5);
    
    $data['slideurl6'] = theme_edifi_get_setting('slide'. $s1 .'url6');
    $slideurl6 = theme_edifi_get_setting('slide'. $s1 .'urltext6');
    $data['slideurltext6'] = theme_edifi_lang($slideurl6);
    
    $data['slideurl7'] = theme_edifi_get_setting('slide'. $s1 .'url7');
    $slideurl7 = theme_edifi_get_setting('slide'. $s1 .'urltext7');
    $data['slideurltext7'] = theme_edifi_lang($slideurl7);
    
    
    $slidedesc = theme_edifi_get_setting('slide'. $s1 .'desc', 'format_html');
    $data['slideposterimg'] = $PAGE->theme->setting_file_url('slide'. $s1 .'posterimage', 'slide'.$s1.'posterimage');
    $data['slidedesc'] = theme_edifi_lang($slidedesc);
    $slideoverlay = theme_edifi_get_setting('overlay'. $s1 .'color');
    $opacity = theme_edifi_get_setting('slideOverlay'. $s1 .'opacity');
    $data['overlaycolor'] = theme_edifi_get_hexa($slideoverlay, $opacity);
    $data['contentcolor'] = theme_edifi_get_setting('content'. $s1 . 'color');
    $data['slideimg'] = theme_edifi_render_slideimg($s1, 'slide'. $s1 .'image');
    $data['contentPosition'] = theme_edifi_get_setting('slide'. $s1 .'contentPosition');
    $data['titleAnimation'] = theme_edifi_get_setting('slide'. $s1 .'titleAnimation');
    $data['descriptionAnimation'] = theme_edifi_get_setting('slide'.$s1.'descriptionAnimation');
    $data['buttonAnimation'] = theme_edifi_get_setting('slide'. $s1 .'buttonAnimation');
    $data['slideEffect'] = theme_edifi_get_setting('slide'. $s1 .'effect');
    $data['slideOverlay_type'] = theme_edifi_get_setting('slide'.$s1.'overlayType');
    $data['slideType'] = theme_edifi_get_setting('slide'.$s1.'type');
    $data['slideVideo'] = theme_edifi_get_setting('slide'.$s1.'video');
    $data['slidevolume'] = theme_edifi_get_setting('slide'. $s1 .'volume');
    $data['videoType'] = edifi_check_video_type($data['slideVideo']);
    $data['cont_Fwidth'] = theme_edifi_get_setting('slide'.$s1.'contFullwidth');
    $data['contentStyle'] = theme_edifi_get_setting('slide'.$s1.'contentStyle');
    $data['overlayStyle'] = theme_edifi_get_setting('slide'.$s1.'overlayStyle');
    $data['widthClass'] = ($data['cont_Fwidth'] == 1) ? " content-fullwidth" : "";
    $data['imgPosition'] = theme_edifi_get_setting('slide'. $s1 .'imagePosition');
    $data['titleAnimation'] = htmlspecialchars($data['titleAnimation']);
    $data['descriptionAnimation'] = htmlspecialchars($data['descriptionAnimation']);
    $data['buttonAnimation'] = htmlspecialchars($data['buttonAnimation']);
    $data['titleAclass'] = ($data['titleAnimation'] != "none") ? "animated ".$data['titleAnimation'] : 'none';
    $data['descAclass'] = ($data['descriptionAnimation'] != "none") ? "animated ".$data['descriptionAnimation'] : 'none';
    $data['btnAclass'] = ($data['buttonAnimation'] != "none") ? "animated ".$data['buttonAnimation'] : "none";

    $data['slidecaption'] = theme_edifi_lang($data['slidecaption']);
    // $data['slideurltext1'] = theme_edifi_lang($data['slideurltext1']);
    $data['slidedesc'] = theme_edifi_lang($data['slidedesc']);
    $cont_width = theme_edifi_get_setting('slide'. $s1. 'contWidth');

    $data['overlayClass'] = "";
    $data['canvasClass'] = "";
    if ($cont_width == "auto") {
        $cont_width = "auto";
    } else {
        $cont_width = intval($cont_width);
        if ($cont_width > '100' ) {
            $cont_width = '100%';
        } else if ($cont_width <= 0 || empty($cont_width)) {
            $cont_width = "auto";
        } else {
            $cont_width = $cont_width.'%';
        }
    }

    $data['contentClass'] = "";
    if ($data['contentStyle'] == 1) {
        $data['contentClass'] = 'style-one ';
    } else if ($data['contentStyle'] == 2) {
        $data['contentClass'] = 'style-two ';
    } else {
        $data['contentClass'] = 'canvas ';
    }

    $data['cont_width'] = $cont_width;
    if ($data['overlayStyle'] == 2 && $data['contentStyle'] != 3) {
        $data['overlayClass'] = " content-overlayer";
    } else if ($data['overlayStyle'] == 1) {
        $data['overlayClass'] = 'slide-overlay';
    } else {
        $data['overlayClass'] = 'overlay-none';
    }
    $data['contentClass'] .= $data['overlayClass'];
    $data['contentClass'] .= $data['widthClass'];
    $data['contentClass'] .= $data['canvasClass'];

    if (!empty($data['contentPosition'])) {
        $data['contentClass'] .= ' content-'.$data['contentPosition'];
    } else {
        $data['contentClass'] .= " content-centerRight";
    }

    if (empty($data['slideurltext2']) && !empty($data['slideurl2'])) {
        $data['slidefullurl'] = $data['slideurl2'];
    }
    if (empty($data['slideurltext1']) && !empty($data['slideurl1'])) {
        $data['slidefullurl'] = $data['slideurl1'];
    }
    if (!isset($data['slidefullurl'])) {
        $data['slidefullurl'] = '';
    }

    return $data;
}

function theme_edifi_get_slide_controls($numberofslides,  $imgArrs = []) {

    $cType = theme_edifi_get_setting('slideshowControls');
    if ($cType != "NONE") :
        $slideControl = '<span style="position:absolute; bottom: 0px; left: 0px;width: 100%;text-align: center;" class="controls">';
        $slideControl .= '<div style="display: block; margin: 0 auto" class="centeredDotsControls">';
        $s = 1;
        foreach ($imgArrs as $key => $imgArr) {
            $class = ($cType != "THUMB") ? 'doted' : "thumb";
            $slideControl .= '<a class="homepage-carouselLink '.$class.'" data-bs-target="'.$s.'" href="#"><span></span>';
            if ($cType == "THUMB") {
                $slideControl .= html_writer::empty_tag('img', ['src' => $imgArr, 'height' => '50', 'width' => '50' ]);
            }
            $slideControl .= html_writer::end_tag('a');
            $s++;
        }
        $slideControl .= '</div>
    </span>';
        return $slideControl;
    endif;
}

function theme_edifi_get_hexa($hexa, $opacity) {
    if (!empty($hexa)) {
        list($r, $g, $b) = sscanf($hexa, "#%02x%02x%02x");
        if ($opacity == '') {
            $opacity = 0.0;
        } else {
            $opacity = $opacity / 10;
        }
        // print($opacity);exit;
        return "rgba($r, $g, $b, $opacity)";
    }
}

function edifi_check_video_type($url) {
    if (!empty($url)) {
        $urlContent = parse_url($url);
        if (isset($urlContent['host'])) {
            $host = $urlContent['host'];
            if (strpos($host, 'youtube') > 0 ) {
                return "youtube";
            } else if (strpos($host, 'vimeo') > 0) {
                return "VIMEO";
            }
        }
    }
    return "";
}

function edifi_slide_status($data = [], $s1="") {
    if (empty($data)) {
        $data = edifi_slide_get_settings($s1);
    }
    if ($data['slideStatus'] != 0 && $data['slideStatus'] != "") {
        if ($data['slideType'] == "IMAGE") {
            if ($data['slideimg'] != '' && $data['slideimg'] != false ) {
                return true;
            } else {
                return false;
            }
        } else {
            if ($data['slideVideo'] != "") {
                return true;
            } else {
                return false;
            }
        }
    } else {
        return true;
    }
}

function get_edifi_slider() {
    global $PAGE;
    $numberofslides = theme_edifi_get_setting('numberofslides');
    $autoslideshow = theme_edifi_get_setting('autoslideshow');
    $slideinterval = theme_edifi_get_setting('slideinterval');
    $animationTime = theme_edifi_get_setting('slideAnitmationTime');
    $slideinterval = intval($slideinterval);
    $animationTime = intval($animationTime);
    $slideinterval = empty($slideinterval) ? 3000 : $slideinterval;
    $animationTime = empty($animationTime) ? 1500 : $animationTime;
    if ($autoslideshow == 1) {
        $autoslideshow = "true";
    } else {
        $autoslideshow = "false";
    }
    $slideContent = "";
    $imgArr = [];
    $slideHeight = theme_edifi_get_setting('slideHeight'); // Slide Height from user settings.
    $slideHeight = intval($slideHeight);
    if ($slideHeight == "" || $slideHeight > "1300" || $slideHeight < "300") {
        $slideHeight = "550px";
    } else {
        $slideHeight = $slideHeight."px";
    }
    $data['slideHeight'] = $slideHeight;
    $jsdata = [];
    $jsdata['slideinterval'] = $slideinterval;
    $jsdata['autoslideshow'] = $autoslideshow;
    $PAGE->requires->js_call_amd('theme_edifi/front-sliders', 'homeslider', ['data' => $jsdata]);

    if ($numberofslides) { // Check Numberof slide is not null.
        $slideContent .= html_writer::start_tag('div', ['class' => 'homepage-carousel', 'id' => 'container']);
        if ($numberofslides > 1) {
            $slideContent .= '<a href="#" class="prevBtn carousel-control left"> <span aria-hidden="true"></span> </a>';
            $slideContent .= '<a href="#" class="nextBtn carousel-control right"> <span aria-hidden="true"></span> </a> ';
        }

        $slideContent .= html_writer::start_tag('div', ['id' => 'homepage-carousel', 'class' => 'bs-slider ',  'data-interval' => $slideinterval ]);
        for ($s1 = 1; $s1 <= $numberofslides; $s1++) {
            $data = edifi_slide_get_settings($s1);
            $status_slide = edifi_slide_status($data);
            if ($data['slideStatus'] != 0 && $status_slide != 0) :  // Check the current slide is enabled or disabled.
                if ($data['slideType'] == "VIDEO") { // Video slider.
                    $elemClass = " video-slider ";
                    if ($data['videoType'] == 'youtube') {
                        $elemClass .= " youtube";
                    }
                } else {
                    $elemClass = " img-slider ";
                }
                // Slider Section.
                $slideContent .= html_writer::start_tag('div', ['class' => 'carousel-item '.$elemClass,  'data-effect' => $data['slideEffect'] ] );


                if ($data['contentStyle'] == 3 && !empty($data['slidecaption'])) {
                    $slideContent .= "<div><div class='slide-canvas'><p class='iS-TextHole' style='display:none;font-weight:bold;padding:0px 15px;overflow:hidden'>";
                    $slideContent .= "<canvas  class='iS-Canvas'>".$data['slidecaption']."</canvas>";
                    $slideContent .= $data['slidecaption'];
                    $slideContent .= "</p></div></div>";
                }
                $imgArr[$s1] = $data['slideimg'];
                if ($data['overlaycolor'] != '') {
                    $overlaystyle = 'background-color:'.$data['overlaycolor'];
                } else {
                    $overlaystyle = '';
                }
                $slideContent .= html_writer::start_tag('div', ['class' => 'slide-content']);

                if ($data['overlayStyle'] == 1) {

                    $overlayClick = ($data['videoType'] == 'youtube') ? "slideOverlayClick(this)" : "";
                    $slideOverlay = html_writer::tag('div', '', ['class' => 'slide-overlayer', 'onclick' => $overlayClick, 'style' => $overlaystyle ]);
                    if (!empty($data['slidefullurl']) ) {
                        $slideContent .= html_writer::start_tag('a', ['href' => $data['slidefullurl'] ] );
                        $slideContent .= $slideOverlay;
                        $slideContent .= html_writer::end_tag('a');
                    } else {
                        $slideContent .= $slideOverlay;
                    }
                }


                if (!empty($data['slidecaption'])  || !empty($data['slidedesc']) || (!empty($data['slideurltext']) && !empty($data['slideurl']) )) {

                    if ($data['overlayStyle'] == 2 && $data['contentStyle'] != 1) {
                        $c_overlaystyle = $overlaystyle;
                    } else {
                        $c_overlaystyle = '';
                    }
                    if ($data['overlayStyle'] == 2 && $data['contentStyle'] == 1) {
                        $contentoverlaystyle = $overlaystyle;
                    } else {
                        $contentoverlaystyle = '';
                    }
                    $slideContent .= html_writer::start_tag('div', ['class' => 'slide-text '.$data['contentClass'], 'style' => 'display:none;width:'.$data['cont_width'].';'.$contentoverlaystyle]);

                    if ($data['contentStyle'] != 3 ) {
                        $slideContent .= html_writer::tag('h1', $data['slidecaption'], ['class' => $data['titleAclass'], 'data-animation' => 'animated '. $data['titleAnimation'], 'style' => 'color:'.$data['contentcolor'].';'.$c_overlaystyle]);
                    }
                    if ($data['contentStyle'] == 3) {
                        $slideContent .= html_writer::start_tag('p', ['class' => 'canvas-content '.$data['titleAclass'], 'data-animation' => 'animated '. $data['titleAnimation'], 'data-content' => $data['i'], 'style' => 'color:'.$data['contentcolor'].';'.$c_overlaystyle] );
                        $slideContent .= html_writer::end_tag('p');
                    }
                        $slideContent .= html_writer::tag('p', $data['slidedesc'], ['class' => $data['descAclass'] , 'data-animation' => 'animated '. $data['descriptionAnimation'], 'style' => 'color:'.$data['contentcolor'].';'.$c_overlaystyle]);

                    // if ($data['contentStyle'] != 3) {
                    $slideContent .= "<br>";
                    if (!empty($data['slideurl1']) && !empty($data['slideurltext1'])) {
                        $slideTarget1 = (isset($data['slideurltarget1']) && $data['slideurltarget1'] == 1) ? '_blank' : '_self';

                        $slideContent .= html_writer::link($data['slideurl1'], $data['slideurltext1'], ['target' => $slideTarget1, 'class' => 'btn btn-primary '. $data['btnAclass'], 'data-animation' => 'animated '.$data['buttonAnimation'] ] );
                    }
                    if (!empty($data['slideurl2']) && !empty($data['slideurltext2'])) {
                        $slideTarget2 = (isset($data['slideurltarget2']) && $data['slideurltarget2'] == 1) ? '_blank' : '_self';
                        $slideContent .= html_writer::link($data['slideurl2'], $data['slideurltext2'], ['target' => $slideTarget2, 'class' => 'btn btn-primary '. $data['btnAclass'], 'data-animation' => 'animated '.$data['buttonAnimation']] );
                    }
                    //-------------------------------------------------------------------
                    // Code ISLEM PHP  Ligne 355
                    if (!empty($data['slideurl3']) && !empty($data['slideurltext3'])) {
                        $slideTarget3 = (isset($data['slideurltarget3']) && $data['slideurltarget3'] == 1) ? '_blank' : '_self';
                        $slideContent .= html_writer::link($data['slideurl3'], $data['slideurltext3'], ['target' => $slideTarget3, 'class' => 'btn btn-primary '. $data['btnAclass'], 'data-animation' => 'animated '.$data['buttonAnimation']] );
                    }
                    if (!empty($data['slideurl4']) && !empty($data['slideurltext4'])) {
                        $slideTarget4 = (isset($data['slideurltarget4']) && $data['slideurltarget4'] == 1) ? '_blank' : '_self';
                        $slideContent .= html_writer::link($data['slideurl4'], $data['slideurltext4'], ['target' => $slideTarget4, 'class' => 'btn btn-primary '. $data['btnAclass'], 'data-animation' => 'animated '.$data['buttonAnimation']] );
                    }
                    if (!empty($data['slideurl5']) && !empty($data['slideurltext5'])) {
                        $slideTarget5 = (isset($data['slideurltarget5']) && $data['slideurltarget5'] == 1) ? '_blank' : '_self';
                        $slideContent .= html_writer::link($data['slideurl5'], $data['slideurltext5'], ['target' => $slideTarget5, 'class' => 'btn btn-primary '. $data['btnAclass'], 'data-animation' => 'animated '.$data['buttonAnimation']] );
                    }
                    if (!empty($data['slideurl6']) && !empty($data['slideurltext6'])) {
                        $slideTarget6 = (isset($data['slideurltarget6']) && $data['slideurltarget6'] == 1) ? '_blank' : '_self';
                        $slideContent .= html_writer::link($data['slideurl6'], $data['slideurltext6'], ['target' => $slideTarget6, 'class' => 'btn btn-primary '. $data['btnAclass'], 'data-animation' => 'animated '.$data['buttonAnimation']] );
                    }
                    if (!empty($data['slideurl7']) && !empty($data['slideurltext7'])) {
                        $slideTarget7 = (isset($data['slideurltarget7']) && $data['slideurltarget7'] == 1) ? '_blank' : '_self';
                        $slideContent .= html_writer::link($data['slideurl7'], $data['slideurltext7'], ['target' => $slideTarget7, 'class' => 'btn btn-primary '. $data['btnAclass'], 'data-animation' => 'animated '.$data['buttonAnimation']] );
                    }
                    if (!empty($data['slideurl8']) && !empty($data['slideurltext8'])) {
                        $slideTarget8 = (isset($data['slideurltarget8']) && $data['slideurltarget8'] == 1) ? '_blank' : '_self';
                        $slideContent .= html_writer::link($data['slideurl8'], $data['slideurltext8'], ['target' => $slideTarget8, 'class' => 'btn btn-primary '. $data['btnAclass'], 'data-animation' => 'animated '.$data['buttonAnimation']] );
                    }
                    // Code ISLEM PHP

                    $slideContent .= html_writer::end_tag('div');  // Div Slide-text.
                }
                $imageClass = "slide-img ";
                if ($data['slidezoom'] != 0) {
                    $imageClass .= "zoomEffect ";
                    $imageClass .= ($data['slidezoom'] == 1) ? 'zoom-in' : '';
                    $imageClass .= ($data['slidezoom'] == 2) ? 'zoom-out' : '';
                }
                if ($data['slideType'] == "VIDEO") { // Video slider.
                    $slideContent .= html_writer::start_tag('div', ['class' => 'video-block-container']);
                    $slideContent .= edifi_slide_get_video($data); // Get the video for slider.
                    $slideContent .= html_writer::end_tag('div'); // Video-block-container.
                } else {
                    if (!empty($data['slidefullurl'])) {
                        $slideContent .= html_writer::start_tag('a', ['href' => $data['slidefullurl'] ] );
                    }
                    $slideContent .= html_writer::empty_tag('img', ['src' => $data['slideimg'], 'class' => $imageClass]); // Slide Content Image.
                    if ( !empty($data['slidefullurl']) ) {
                        $slideContent .= html_writer::end_tag('a');
                    }
                }
                $slideContent .= html_writer::end_tag('div');  // Div .slide-content.

                $slideContent .= html_writer::end_tag('div');  // Div Carousel-item, End Of Wraper.
            endif;
        }
        $slideContent .= html_writer::end_tag('div');  // Div Carousel.
        $slideContent .= theme_edifi_get_slide_controls($numberofslides, $imgArr);
        $slideContent .= html_writer::end_tag('div');  // Div Carousel.

        /*================== Slider Contents End Here ==================*/
        $toggleslideshow = theme_edifi_get_setting('toggleslideshow');
        if ($toggleslideshow == 1) {
            return $slideContent;
        }
    }
}