<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * A drawer based layout for the edifi theme.
 *
 * @package   theme_edifi
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author    LMSACE Dev Team
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir . '/behat/lib.php');
require_once($CFG->dirroot . '/course/lib.php');

// Add block button in editing mode.
$addblockbutton = $OUTPUT->addblockbutton();

require_once($CFG->dirroot."/theme/edifi/classes/header_block.php");
require_once($CFG->dirroot."/theme/edifi/classes/footer_block.php");
require_once(__DIR__ . '/includes/slideshow.php');

$templatecontext = array_merge($headercontext, $footercontext);

if (isloggedin()) {
    $courseindexopen = (get_user_preferences('drawer-open-index', true) == true);
    $blockdraweropen = (get_user_preferences('drawer-open-block') == true);
} else {
    $courseindexopen = false;
    $blockdraweropen = false;
}

if (defined('BEHAT_SITE_RUNNING')) {
    $blockdraweropen = true;
}

$extraclasses = ['uses-drawers'];
if ($courseindexopen) {
    $extraclasses[] = 'drawer-open-index';
}

$blockshtml = $OUTPUT->blocks('side-pre');
$hasblocks = (strpos($blockshtml, 'data-block=') !== false || !empty($addblockbutton));
if (!$hasblocks) {
    $blockdraweropen = false;
}
$courseindex = core_course_drawer();
if (!$courseindex) {
    $courseindexopen = false;
}

$bodyattributes = $OUTPUT->body_attributes($extraclasses);
$forceblockdraweropen = $OUTPUT->firstview_fakeblocks();

$secondarynavigation = false;
$overflow = '';
if ($PAGE->has_secondary_navigation()) {
    $tablistnav = $PAGE->has_tablist_secondary_navigation();
    $moremenu = new \core\navigation\output\more_menu($PAGE->secondarynav, 'nav-tabs', true, $tablistnav);
    $secondarynavigation = $moremenu->export_for_template($OUTPUT);
    $overflowdata = $PAGE->secondarynav->get_overflow_menu_data();
    if (!is_null($overflowdata)) {
        $overflow = $overflowdata->export_for_template($OUTPUT);
    }
}

$primary = new core\navigation\output\primary($PAGE);
$renderer = $PAGE->get_renderer('core');
$primarymenu = $primary->export_for_template($renderer);
$buildregionmainsettings = !$PAGE->include_region_main_settings_in_header_actions() && !$PAGE->has_secondary_navigation();
// If the settings menu will be included in the header then don't add it here.
$regionmainsettingsmenu = $buildregionmainsettings ? $OUTPUT->region_main_settings_menu() : false;

$header = $PAGE->activityheader;
$headercontent = $header->export_for_template($renderer);

$headerStyle = theme_edifi_header_style('CENTER');
if ($headerStyle) {
    $nodes = $primarymenu['moremenu']['nodearray'];
    $centerMenu = theme_edifi_center_menu_split($nodes);
    $primarymenu['moremenu']['centermenu'] = $centerMenu;
}

$contextid = context_system::instance()->id;
$PAGE->requires->js_call_amd('theme_edifi/select_category','init',['contextid' => $contextid]);
$PAGE->requires->css(new moodle_url('/theme/edifi/style/slick.css'));
$PAGE->requires->css(new moodle_url('/theme/edifi/style/jquery.countimator.wheel.css'));
$PAGE->requires->css(new moodle_url('/theme/edifi/style/style.css'));
$PAGE->requires->js(new moodle_url('/theme/edifi/javascript/frontpage.js'));
$PAGE->requires->js(new moodle_url('/theme/edifi/javascript/jquery.countimator.js'));
//$PAGE->requires->js(new moodle_url('/theme/edifi/javascript/jarallax.js'));
$PAGE->requires->js(new moodle_url('/theme/edifi/javascript/jquery.properload.js'));
$PAGE->requires->js(new moodle_url('/theme/edifi/javascript/vanilla.filterizr.min.js'));

    $titlearr = array(
        'site-news' => theme_edifi_lang(theme_edifi_get_setting('sitenews_title')),
        'courses' => '',
        'available-course' => theme_edifi_lang(theme_edifi_get_setting('availablecourse_title')),
        'mycourses' => theme_edifi_lang(theme_edifi_get_setting('mycourse_title')),
        'categories' => theme_edifi_lang(theme_edifi_get_setting('coursecat_title')),
        'combolist' => theme_edifi_lang(theme_edifi_get_setting('combolist_title'))
        );

    $descarr = array(
      'site-news' => theme_edifi_lang(theme_edifi_get_setting('sitenews_desc')),
      'courses' => '',
      'available-course' => theme_edifi_lang(theme_edifi_get_setting('availablecourse_desc')),
      'mycourses' => theme_edifi_lang(theme_edifi_get_setting('mycourse_desc')),
      'categories' => theme_edifi_lang(theme_edifi_get_setting('coursecat_desc')),
      'combolist' => theme_edifi_lang(theme_edifi_get_setting('combolist_desc'))
    );
    $PAGE->requires->data_for_js('title', $titlearr);
    $PAGE->requires->data_for_js('descarr', $descarr);
    $PAGE->requires->data_for_js('noimage_url', $OUTPUT->image_url('no-image', 'theme')->out(false));

    $slidercontent = get_edifi_slider();

$templatecontext += [
    'sitename' => format_string($SITE->shortname, true, ['context' => context_course::instance(SITEID), "escape" => false]),
    'output' => $OUTPUT,
    'sidepreblocks' => $blockshtml,
    'hasblocks' => $hasblocks,
    'bodyattributes' => $bodyattributes,
    'courseindexopen' => $courseindexopen,
    'blockdraweropen' => $blockdraweropen,
    'courseindex' => $courseindex,
    'primarymoremenu' => $primarymenu['moremenu'],
    'secondarymoremenu' => $secondarynavigation ?: false,
    'mobileprimarynav' => $primarymenu['mobileprimarynav'],
    'usermenu' => $primarymenu['user'],
    'langmenu' => $primarymenu['lang'],
    'forceblockdraweropen' => $forceblockdraweropen,
    'regionmainsettingsmenu' => $regionmainsettingsmenu,
    'hasregionmainsettingsmenu' => !empty($regionmainsettingsmenu),
    'overflow' => $overflow,
    'headercontent' => $headercontent,
    'addblockbutton' => $addblockbutton,
    'slidercontent' => $slidercontent,
];

echo $OUTPUT->render_from_template('theme_edifi/frontpage', $templatecontext);
