/************************************************************************
 * **************************** EDIFI THEME JS ****************************
 * ************************************************************************/


//window.onload = function () { hideLoader(); }
$(window).on('load', function () {

    var loader = document.getElementById('theme_loader');
    if (loader) {
        var style = window.getComputedStyle(loader);
        if (style.display != 'none') {
            loader.style.visibility = "hidden";
        }
    }
});

$(function () {
    $('#frontpage-category-combo .course-list-combo').find('.category-course-list .carousel.slide').each(function () {

        $(this).find('.carousel-item:first').addClass('active');
    });

    $('.dropdown, .dropdown-submenu').on('mouseenter', function (event) {
        if ($(window).width() >= 992) {
            $('.dropdown').not($(this)).removeClass('show');
            $(this).find('.dropdown-menu:eq(0)').stop(true, true).delay(100).addClass('show');
            $(this).addClass('show');
        }
    }).on('mouseleave', function (event) {

        if ($(window).width() >= 992) {
            if (!$(this).hasClass('active')) {
                $(this).find('.dropdown-menu:eq(0)').stop(true, true).delay(100).removeClass('show');
                $(this).removeClass('show');
            }
        }
    });


    var navHeight = parseInt($('nav#header').height()) - parseInt($('#nav-drawer').css('top')) + parseInt(15);
    $('#nav-drawer ').css({ 'padding-top': '35px' })

    var themeColor = edifiData.theme_color;
    // Remove the Transparent header if homepage carousel.
    if ($('#homepage-carousel').length == '') {
        $('nav#header').removeClass('transparent-header');
    }

    // var body_top = $('#header').outerHeight();
    if ($('nav#header').hasClass('transparent-header')) {
        $("body").css("margin-top", 0);
    }

    // Custom menu > mobile device toggle.
    $(".theme-custom-menubar-xs a.menu-toggle-btn").on('click', function () {
        $("div.menu-toggle-content").slideToggle();
    });

    /*------- Check navbar button status -------- */
    if ($("#header .navbar-nav button").attr('aria-expanded') === "true") {
        $("#header .navbar-nav").find('button').addClass('is-active');
    }

    $("#header .navbar-nav .left-block button").click(function () {
        if ($(this).attr('aria-expanded') === "false") {
            $("#header .navbar-nav .left-block").find('button').addClass('is-active');
        } else {
            $("#header .navbar-nav .left-block").find('button').removeClass('is-active');
        }
    });
    if ($("#header").hasClass('transparent-header')) {
        var transparent = "true";
    } else {
        var transparent = "false";
    }
    var footerdiv = $('footer#footer .footer-main .row').find('div').not('div.clearfix');
    if (footerdiv.length <= 0) {
        $('footer#footer .footer-main').hide();
    }

    // Animation for header to sitcky header bg color.
    function headerAnim() {
        $('#header').css({
            '-webkit-transition': 'background-color 0.2s ease-in',
            '-moz-transition': 'background-color 0.2s ease-in',
            '-o-transition': 'background-color 0.2s ease-in',
            'transition': 'background-color 0.2s ease-in',
        })
    }

    // Header animation function for header to sticky header height and background.
    function headerSizeAnim() {
        $('.active-sticky img').animate({
            // 'height': '100px',
            'background': themeColor,
        }, 100)
    }

    // Check header is top position else changes the header to sticky header.
    if ($(window).scrollTop() > 75) {

        $('nav#header').addClass('active-sticky');
        $('nav#header').removeClass('trans-top');
        headerAnim();
        headerSizeAnim();
    }

    $(window).on('scroll', function () {
        if ($("#header").hasClass('transparent-header')) {
            var transparent = "true";
        } else {
            var transparent = "false";
        }
        if ($(this).scrollTop() > 75) {
            if (!$('nav#header').hasClass('active-sticky')) {
                if (transparent == "true") {
                    $('nav#header').removeClass('trans-top');
                    headerAnim();
                }
                headerSizeAnim();
                $("nav#header").addClass('active-sticky');
            }
        } else {
            if ($('nav#header').hasClass('active-sticky')) {
                if (transparent == "true") {
                    $('nav#header').addClass('trans-top');
                    headerAnim();
                }
                $("nav#header").removeClass('active-sticky');
            }
        }

        if ($(this).scrollTop() > 150) {
            $('#backToTop').fadeIn('slow');
            $('#custom_save').fadeIn('slow');
        } else {
            $('#backToTop').fadeOut('slow');
        }

        if ($(this).scrollTop() >= $(window).height) {
            $('#backToTop').fadOut('slow');
        }
        _headerHeight();

    });
    _headerHeight();

    // Find the header height and set the margin top to the navdrawer.
    function _headerHeight() {
        var headerHeight = $('nav#header').height();
        var navDrawer = $('#nav-drawer');
        var body = $('body');
        if (navDrawer.css('margin-top') != headerHeight) {
            navDrawer.css({ marginTop: headerHeight });
        }
        if (!$("#header").hasClass('transparent-header')) {
            if (body.css('margin-top') != headerHeight) {
                body.animate({ marginTop: headerHeight }, 10);
            }
        }
    }

    // Hide The BacktoTop button in top.
    $('#backToTop').click(function () {
        $("html, body").animate({ scrollTop: 0 }, 'slow');
        return false;
    });

    // Add a parent div for site news forum inner contents.
    $('#site-news-forum .forumpost').each(function () {
        var $this = $(this);
        var href = $(this).find('.side .link').find('a').attr('href');
        $this.find('.header .topic .subject').wrapInner('<a href="' + href + '"></a>');
        $this.find('.maincontent .content .attachedimages').find('img').wrap('<a href="' + href + '"></a>');
    })

    /****** Material design ********/
    $(".btn").each(function () {
        $(this).addClass('waves-effect ');
    })
    $("#nav-drawer").find('nav a.list-group-item').addClass(' waves-effect waves-teal');
    $("#nav-drawer").find('nav a.list-group-item.font-weight-bold').addClass('active');
    $('form#adminsettings button[type=submit]').addClass('org-btn')
    $('form#adminsettings button[type=submit]').clone().removeClass('org-btn').addClass('floating-button').insertAfter('form#adminsettings button[type=submit]');

    /** Find settings button inside the window viewport *
    */
    function scrollbutton(elem) {
        var
            $elem = elem,
            $window = $(window),
            docViewTop = $window.scrollTop(),
            docViewBottom = docViewTop + $window.height(),
            elemTop = $elem.offset().top,
            elemBottom = elemTop + $elem.height();
        return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
    }
    // Function for scroll lisstner.

    function scrollListener() {
        var element = $('form#adminsettings button[type=submit].org-btn');

        if (element.length != 0) {

            var ps = scrollbutton(element);

            if (ps == true) {
                $(".floating-button").hide();
            } else {
                $('.floating-button').show();
            }
        }
    }
    // Call the function when the window is scroll down.
    if ($('body').hasClass('theme-floating-btn')) {
        $(window).on('scroll touchmove', scrollListener);
    }

    /* ----- Create the accordion for the custom blocks or tabs in settings page */
    var toggelSection = ['#theme_edifi_general', '#theme_edifi_counter', '#theme_edifi_marketingspot', '#theme_edifi_slideshow', '#theme_edifi_frontpage', '#theme_edifi_tmonialhead', '#theme_edifi_ourPartners', '#theme_edifi_footer'];
    $.each(toggelSection, function (key, value) {
        var h3 = $(value).find('h3.main');
        var block = value.split("_")[2]; // Get the settings heading name from the given id's.
        h3.each(function (key) {
            var $this = $(this);
            var childid = block + "_toggle_" + key;
            var hidden = "true";
            var toggleChild = '<div class="child-toggle ' + childid + '" id="child_' + childid + '" data-hidden="' + hidden + '" />';
            $(this).nextUntil('h3.main').wrapAll(toggleChild);
            var toggleHead = '<div class="edifi-toggle-head" id="' + childid + '">';
            $this.wrap(toggleHead);
            var iconclass = (hidden == "false") ? 'fa-minus-square' : 'fa-plus-square';
            var toggleIcon = '<div class="toggle-icon" style="display:inline;" > <i class="fa ' + iconclass + '"> </i></div>';
            $this.append(toggleIcon);
        })
    })

    /******** Event for accordion clicked  *********/
    $(".edifi-toggle-head").click(function () {
        var $this = $(this);
        var parentid = $this.parent('fieldset').parent('div.tab-pane').attr('id');
        if (parentid.length != "") {
            var parent = $("#" + parentid);
        } else {
            var parent = $(".tab-pane.active[aria-expanded=true]");
        }
        var headid = $this.attr('id');
        var childid = "child_" + headid;
        var child = $("#" + childid);
        var dataHidden = $("#" + childid).attr('data-hidden');
        if (dataHidden == "false") {
            child.slideUp('slow');
            child.attr('data-hidden', 'true');
        } else {
            child.slideDown('slow');
            child.attr('data-hidden', 'false');
        }
        parent.find('.child-toggle').not(child).slideUp('slow').attr('data-hidden', 'true');

        toggleicon2(parentid);
    })

    /******** Set the icon for all accortions under the active parent tab *********/
    function toggleicon2(parentid) {
        // Alert(parentid);
        if (parentid.length != "") {
            var parent = $("#" + parentid);
        } else {
            var parent = $(".tab-pane.active[aria-expanded=true]");
        }
        parent.find('.edifi-toggle-head').each(function () {
            var $this = $(this);
            var childid = $(this).attr('id');
            // alert(childid).
            var dataHidden = parent.find('#child_' + childid).attr('data-hidden');
            if (dataHidden == "false") {
                $this.find('h3 .toggle-icon i').addClass('fa-minus-square').removeClass('fa-plus-square');
            } else {
                $this.find('h3 .toggle-icon i').addClass('fa-plus-square').removeClass('fa-minus-square');
            }
        });
    }
    // **** Import Select alert for confirmation ****//
    $('input[name=s_theme_edifi_importDemo]').change(function () {
        var $this = $(this);
        if ($(this).prop('checked') == true) {
            var $msg = 'Importing demo content will override the current settings of the edifi theme and moodle frontpage items.';

            require(['core/notification'], function (notification) {
                notification.confirm('Please confirm', $msg, 'Continue', 'cancel', function () {
                }, function () {
                    $this.prop('checked', false);
                });
            });
        }
    })

    require(['jquery', 'core/modal', 'core/modal_factory', 'core/fragment', 'core/notification'], function ($, Modal, ModalFactory, fragment, notification) {

        $(".footer-block.footer-block4 li").each(function () {
            var href = $(this).find('img').attr('src');
            var img = document.createElement('img');
            img = $(img);
            img.attr('href', href);
            var img = "<img style='max-width:1000px;max-height:1000px;' class='popup-image' src=" + href + ">";
            var trigger = $(this).find('img');

            ModalFactory.create({
                body: img,
                large: true,
            }, trigger)
                .done(function (modal) {
                    // Do what you want with your new modal.
                });
        }); // required.
    });
    $(".child-toggle[data-hidden=true]").hide();
    var marketing = ['marketingspot_toggle_2', 'marketingspot_toggle_3', 'marketingspot_toggle_4', 'marketingspot_toggle_5']
    var spot1Child = '<div class="child-toggle marketingspot_toggle_1" id="child_marketingspot_toggle_1" data-hidden="true" style="display:none" />';
    $("#marketingspot_toggle_1").after(spot1Child);
    $.each(marketing, function (key, value) {
        $('#' + value).appendTo('.marketingspot_toggle_1');
        $('.' + value).appendTo('.marketingspot_toggle_1');
        $('#' + value).find('i').hide();
        $('#' + value).children().unwrap();
        $('.' + value).children().unwrap();
        // $(this).hide();
    })
    window.onload = function () {
        $('div.coursebox').find('.summary').addClass('summary-content');
        $('div.frontpage-categories').find('.content').addClass('summary-content');
    };
});








