document.addEventListener("DOMContentLoaded", function () {
    const form = document.querySelector('form#signup');
    if (!form) return;

    form.addEventListener("submit", function (e) {
        let valid = true;
        let firstInvalid = null;

        const fields = form.querySelectorAll("input[type='text'], input[type='email'], input[type='password'], select, textarea");

        fields.forEach(function (field) {
            if (field.offsetParent !== null && field.value.trim() === "") {
                field.style.border = "2px solid red";
                valid = false;
                if (!firstInvalid) {
                    firstInvalid = field;
                }
            } else {
                field.style.border = ""; // reset if valid
            }
        });

        if (!valid) {
            e.preventDefault();
            alert("Merci de remplir tous les champs obligatoires.");
            firstInvalid.focus();
        }
    });
});
