
<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Web services for theme_edifi.
 *
 * @package    theme_edifi
 * @copyright  2020 LMSACE DEV TEAM.
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir . "/externallib.php");

class theme_edifi_external extends external_api {

	public static function get_category_courses_parameters() {

		return new external_function_parameters(
            array(
                'categoryid' => new external_value( PARAM_RAW, 'Category id'),
                'parentid' => new external_value(PARAM_RAW, 'parent id', VALUE_OPTIONAL)
            )
        );
	}

	public static function get_category_courses($categoryid,$parentid='') {
		global $CFG, $PAGE;
		$PAGE->set_context(\context_system::instance());
		require_once($CFG->dirroot.'/theme/edifi/lib.php');
		return ['html' => theme_edifi_output_fragment_get_category_courses(['categoryid' => $categoryid,'parentid'=> $parentid])];
	}

	public static function get_category_courses_returns() {

		return new external_single_structure(
			array(
				'html' => new external_value(PARAM_RAW, 'Category content')      
			)
		);
	}


}