<?php
/**
 * @package    theme_edifi
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author    LMSACE Dev Team
 *
 */

defined('MOODLE_INTERNAL') || die();

/**
 * Return the set of valuse for the footer blocks template.
 * @return type|array
 */
function footer_template() {
    global $OUTPUT, $SITE;
    $footnote = theme_edifi_get_setting('footnote', 'format_html');
    $copyright = theme_edifi_lang(theme_edifi_get_setting('copyright', true));
    $address = theme_edifi_lang(theme_edifi_get_setting('address', 'format_html'));
    $emailid = theme_edifi_lang(theme_edifi_get_setting('emailid'));
    $phoneno = theme_edifi_lang(theme_edifi_get_setting('phoneno'));
    $s_contact = get_string('contact', 'theme_edifi');
    $s_phone = get_string('phone');
    $s_emailid = get_string('emailid', 'theme_edifi');
    $s_connectus = get_string('connectus', 'theme_edifi');

    $backToTop_status = theme_edifi_get_setting('backToTop_status');
    $footerLogo = theme_edifi_footer_logo();
    $socialmedia = theme_edifi_social_media();

    if (!empty($address) || !empty($emailid) || !empty($phoneno) || !empty($footerLogo)) {
        $centerFooter = true;

    } else {
        $centerFooter = false;
    }
    if (!empty($copyright) || !empty($socialmedia['sicon1']) || !empty($socialmedia['sicon2']) || !empty($socialmedia['sicon3']) || !empty($socialmedia['sicon4']) ) {
        $bottomFooter = true;
    } else {
        $bottomFooter = false;
    }
    $footer = theme_edifi_footer_blocks();
    $footerbClass = theme_edifi_footer_class(array(''), $centerFooter);

    if(isloggedin())
        $loggin = 1;
    else
        $loggin = 0;

    $templatecontext = [
        "footnote" => $footnote,
        "copyright" => $copyright,
        "address" => $address,
        "emailid" => $emailid,
        "phoneno" => $phoneno,
        "s_contact" => $s_contact,
        "s_phone" => $s_phone,
        "s_emailid" => $s_emailid,
        "s_connectus" => $s_connectus,
        "backToTop" => $backToTop_status,
        "footerLogo" => $footerLogo,
        'footer' => $footer,
        'social' => $socialmedia,
        'footerbClass' => $footerbClass,
        'centerFooter' => $centerFooter,
        'bottomFooter' => $bottomFooter,

    ];
    return $templatecontext;
}
$footercontext = footer_template();

?>