<?php
/**
 * @package    theme_edifi
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author     LMSACE Dev Team
 *
 */

namespace theme_edifi;
use moodle_url;
use html_writer;
use outputlib;
/**
 * Theme Edifi Used Extra Blocks Class.
 */
class extra_blocks {

    public $theme = "";

    /**
     * Construct function for edifi blocks.
     * @return type
     */
    public function __construct() {
        global $PAGE, $CFG;

        $this->theme = $PAGE->theme;
    }

    public function edifi_news_events() {
        $content = '';
        if (theme_edifi_get_setting('newsblock')) {
            $check = theme_edifi_get_setting('newsblockcontent', 'format_html');
            if (!empty($check)) {
                $content .= html_writer::start_tag('div', array('class' => 'site-noticearea'));
                $content .= html_writer::start_tag('div', array('class' => 'container-fluid'));
                $content .= theme_edifi_lang(theme_edifi_get_setting('newsblockcontent', 'format_html'));
                $content .= html_writer::end_tag('div');
                $content .= html_writer::end_tag('div');
            }
        }
        return $content;
    }

    /**
     * Class for featured courses block, this function returns the courses based on id's which is given by the user in theme settings page
     * @return string
     */
    public function featured_courses() {
        global $CFG, $PAGE, $theme;
        $courses = array();
        $topContent = $mainContent = $footContent = " ";
        $fcourses = $this->theme->settings->featured_courses;
        $fcourse_title = theme_edifi_get_setting('fcoursetitle');
        if (!empty($fcourse_title)) {
            $fcourse_title = theme_edifi_lang($fcourse_title);
        } else {
            $fcourse_title = get_string('fcourses', 'theme_edifi');
        }
        $fcourse_desc = theme_edifi_get_setting('fcoursedesc');
        $fcourse_desc = theme_edifi_lang($fcourse_desc);
        if (!empty($fcourses) ) {
            $fcoursesArr = explode(',', $fcourses);
            $fcoursesSpl = array_splice($fcoursesArr, 6);

            // $context = context_system::instance();
            // print_r($fcoursesArr);exit;
            $fcoursesArr = $this->check_course_id($fcoursesArr);
            if (!empty($fcoursesArr)) {
                $courses = array_combine(range(1, count($fcoursesArr)), $fcoursesArr);
            }
            if (!empty($courses)) {
                $topContent = html_writer::start_tag('div', array('class' => 'featured-course'));
                $topContent .= html_writer::start_tag('div', array('class' => 'container-fluid'));
                $topContent .= html_writer::tag('h2', format_string($fcourse_title), array('class' => 'title-headings'));
                $topContent .= html_writer::tag('p', $fcourse_desc);
                $topContent .= html_writer::start_tag('div', array('class' => 'row'));
                foreach ($courses as $key => $course_id) {
                    $course_id = intval($course_id);
                    if (!empty($course_id) && $course_id != "0" && is_integer($course_id)) {
                        if ($key == 1 || $key == 4) {
                            $mainContent .= $this->featured_block_large($course_id);
                        } else {
                            $mainContent .= $this->featured_block_small($course_id);
                        }
                    }
                }
                $footContent = html_writer::end_tag('div'); // .row.
                $footContent .= html_writer::end_tag('div'); // .container.
                $footContent .= html_writer::end_tag('div'); // .featured-course.
            }
            return $topContent.$mainContent.$footContent;
        }
    }

    /**
     * Class returns the featured block large size segments course and design details.
     * @param int $course_id
     * @return string
     */
    public function featured_block_large($course_id) {
        global $OUTPUT, $PAGE;
        $mainContent = "";
        $readmore = get_string ('readmore', 'theme_edifi');
        $view = get_string ('view');
        $course = get_course_content($course_id);
        $mainContent .= html_writer::start_tag('div', array('class' => 'col-lg-6 col-md-6'));
        $mainContent .= html_writer::start_tag('div', array('class' => 'card-block card-element'));
        $mainContent .= html_writer::start_tag('div', array('class' => 'card-img'));
        $mainContent .= html_writer::empty_tag('img', array('src' => $course['imgurl']));
        $mainContent .= html_writer::end_tag('div'); // .card-img.
        $mainContent .= html_writer::start_tag('div', array('class' => 'card-content'));
        $mainContent .= html_writer::start_tag('div', array('class' => 'content-overlay'));
        $mainContent .= html_writer::start_tag('a', array('href' => $course['url']));
        $mainContent .= html_writer::tag('h3', $course['name'], array('class' => 'd-block d-md-none'));
        $mainContent .= html_writer::end_tag('a');
        $mainContent .= html_writer::tag('p', $course['summary'], array('class' => 'card-summary') );
        $mainContent .= html_writer::link($course['url'], $view, array('class' => 'viewcourse', ));
        $mainContent .= html_writer::tag('span', $readmore, array('class' => 'readmore', 'data-param' => $course_id, 'id' => 'feature_read_'.$course_id ));
        $mainContent .= html_writer::end_tag('div'); // .card-overlay.
        $mainContent .= html_writer::end_tag('div'); // .card-content.
        $mainContent .= html_writer::start_tag('div', array( 'class' => 'card-header' ));
        $mainContent .= html_writer::tag('h3', $course['name'] );
        $mainContent .= html_writer::end_tag('div'); // .card-header.
        $mainContent .= html_writer::end_tag('div'); // .card-block.
        $mainContent .= html_writer::end_tag('div'); // .col-md-6
        return $mainContent;
    }

    /**
     * Class returns the featured block small contents.
     * @param type $course_id
     * @return type
     */
    public function featured_block_small($course_id) {
        global $OUTPUT;
        $mainContent = "";
        $course = get_course_content($course_id);
        $readmore = get_string ('readmore', 'theme_edifi');
        $view = get_string ('view');
        $mainContent .= html_writer::start_tag('div', array( 'class' => 'col-lg-3 col-md-6' ));
        $mainContent .= html_writer::start_tag('div', array( 'class' => 'card-block' ));
        $mainContent .= html_writer::start_tag('div', array( 'class' => 'card-img' ));
        $mainContent .= html_writer::empty_tag('img', array('src' => $course['imgurl'] ));
        $mainContent .= html_writer::end_tag('div'); // .card-img.
        $mainContent .= html_writer::start_tag('div', array( 'class' => 'card-content'));
        $mainContent .= html_writer::start_tag('div', array( 'class' => 'content-overlay'));
        $mainContent .= html_writer::start_tag('a', array('href' => $course['url']));
        $mainContent .= html_writer::tag('h3', $course['name'], array('class' => 'd-block d-md-none'));
        $mainContent .= html_writer::end_tag('a');

        $mainContent .= html_writer::tag('p', $course['summary'], array('class' => 'card-summary'));

        $mainContent .= html_writer::link($course['url'], $view, array('class' => 'viewcourse', ));

        $mainContent .= html_writer::tag('span', $readmore, array('class' => 'readmore', 'data-param' => $course_id, 'id' => 'feature_read_'.$course_id ));
        $mainContent .= html_writer::end_tag('div'); // .card-overlay.
        $mainContent .= html_writer::end_tag('div'); // .card-content.
        $mainContent .= html_writer::start_tag('div', array('class' => 'card-header'));
        $mainContent .= html_writer::tag('h3', $course['name']);
        $mainContent .= html_writer::end_tag('div'); // .card-header.
        $mainContent .= html_writer::end_tag('div'); // .card-block.
        $mainContent .= html_writer::end_tag('div'); // .col-md-3
        return $mainContent;
    }
    public static function combo_coursebox($course_ch, $filter_id = "") {
        $course = get_course_content($course_ch->id);
        /*$readmore = "View";*/
        $view = get_string ('view');
        $mainContent = html_writer::start_tag('div', array( 'class' => 'col-md-4 col-sm-6 col-xs-12 filtr-item', "data-category" => $filter_id, 'data-sort' => $course['name'] ));
        $mainContent .= html_writer::start_tag('div', array( 'class' => 'card' ));
        $mainContent .= html_writer::start_tag('div', array( 'class' => 'card-img' ));
        $mainContent .= html_writer::empty_tag('img', array('src' => $course['imgurl'], "width" => "1280", "height" => "853", "alt" => "img-1" ));
        $mainContent .= html_writer::end_tag('div'); // .card-img.
        $mainContent .= html_writer::start_tag('div', array( 'class' => 'course-content' ));
        $mainContent .= html_writer::tag('h3', $course['name'], array());
        $link = new moodle_url('/course/view.php', array('id' => $course_ch->id));
        $mainContent .= html_writer::link($link, $view, array("class" => "btn btn-primary card-link"));

        $mainContent .= html_writer::end_tag('div'); // .card-content.
        $mainContent .= html_writer::end_tag('div'); // .card-block.
        $mainContent .= html_writer::end_tag('div'); // .col-md-3
        return $mainContent;
    }

    /**
     * Check the given course ids are correct and clear wrong ids.
     * @param type|array $rcourseids
     * @return type|array
     */
    public function check_course_id($rcourseids) {
        global $DB;
        if (!empty($rcourseids)) {
            foreach ($rcourseids as $key => $rcourseid) {
                if (empty($rcourseid) || !is_integer($rcourseid)) {
                    if (!$DB->get_record('course', array('id' => $rcourseid))) {
                        unset($rcourseids[$key]);
                    }
                }
            }
        }
        return $rcourseids;
    }

    /**
     * Testimonials block html contents.
     * @param type|string $counttype
     * @return type
     */
    public function theme_edifi_testimonials($counttype= "") {

        global $CFG, $PAGE, $OUTPUT;
        $content = '';
        $num = 0;
        $toggletmonial = theme_edifi_get_setting('toggletmonial');
        $tmonial_desc = theme_edifi_get_setting('tmonialDesc');
        $tmonial_desc = theme_edifi_lang($tmonial_desc);
        if ($toggletmonial != 1) {
            return '';
        }
        $number = $PAGE->theme->settings->numberoftmonials;

        $testimonial_title = theme_edifi_get_setting('tmonialTitle');
        $testimonial_title = (!empty($testimonial_title)) ? $testimonial_title : get_string('tmonialTitle_default', 'theme_edifi');
        $testimonial_title = theme_edifi_lang($testimonial_title);
        if (!empty($number)) {

            $numberRange = range(0, $number);
            $numberArr = array_chunk($numberRange, 3);

            $content .= html_writer::start_tag('div', array('class' => 'testimonial-block'));
            $content .= html_writer::start_tag('div', array('class' => 'container-fluid'));
            // $span = html_writer::tag('span', ' <i class="fa fa-heart"></i>');
            $content .= html_writer::tag('h2', $testimonial_title , array('class' => 'title-headings'));
            $content .= html_writer::tag('p', $tmonial_desc);
            // $content .= html_writer::start_tag('div', array('class' => 'tmonial-nav'));
            $content .= html_writer::start_tag('div', array('class' => 'testimonial-content'));
            if ($number > 5) {
                    $content .= html_writer::start_tag('div', array('class' => 'tmonial-button'));
                 $content .= html_writer::link('javascript:void(0)', '<span aria-hidden="true"></span>', array('class' => 'prevBtn') );
                    $content .= html_writer::link('javascript:void(0)', '<span aria-hidden="true"></span>', array('class' => 'nextBtn') );
                    $content .= html_writer::end_tag('div'); //tmonial-button

            }

            $content .= html_writer::start_tag('div', array('class' => 'tmonial-nav'));

            foreach ($numberRange as $key) {
                $data = $this->get_testimonial_contents($key);
                if (!empty($data['text'])) {
                    $content .= html_writer::start_tag('div', array('class' => 'card-img tmonial-li'));
                    $content .= html_writer::start_tag('div', array('class' => 'testimonial-img'));
                    $content .= html_writer::tag('div', '', array('class' => 'content-overlay'));
                    $content .= html_writer::empty_tag('img', array('src' => $data['imgurl'],  'alt' => 'img-1' ));
                    $content .= html_writer::end_tag('div'); // .card-img.
                    $content .= html_writer::end_tag('div'); // .card-img.
                    $num++;

                }

            }
            $content .= html_writer::end_tag('div');  // tmonial-nav.
            // $content .= html_writer::end_tag('div');  // .row.
            // $content .= html_writer::end_tag('div');  // .row.

            $content .= html_writer::start_tag('div', array('class' => 'tmonial-slick '));
            // $content .= html_writer::start_tag('div', array('class' => 'row'));
            foreach ($numberRange as $value) {
                $data = $this->get_testimonial_contents($value);
                if (!empty($data['text'])) {
                    $content .= html_writer::start_tag('div', array('class' => 'card-block'));
                    $content .= html_writer::start_tag('div', array('class' => 'card-text'));
                    $content .= html_writer::tag('h2', theme_edifi_lang($data['uname']));
                    $content .= html_writer::tag('span', theme_edifi_lang($data['utype']));
                    $content .= html_writer::end_tag('div'); // .card-text.
                    $content .= html_writer::start_tag('div', array('class' => 'card-content'));
                    $content .= html_writer::tag('p', theme_edifi_lang($data['text']));
                    $content .= html_writer::end_tag('div');  // .card-content.
                    $content .= html_writer::end_tag('div');  // .card-block.
                }
            }
            // $content .= html_writer::end_tag('div');
            $content .= html_writer::end_tag('div');  // .tmonial-slick.
            $content .= html_writer::end_tag('div');  // .testimonial-content.
            $content .= html_writer::end_tag('div');  // .container.
            $content .= html_writer::end_tag('div');  // .testimonial-block.
        }
        $jsdata =[];
        $tmonial_autoplay = theme_edifi_get_setting('tmonial_autoplay');
        $tmonial_autotime = theme_edifi_get_setting('tmonial_autotime');
        $jsdata['tmonial_autoplay'] = (!empty($tmonial_autoplay)) ? true : false;
        $jsdata['tmonial_autotime'] = (!empty($tmonial_autotime)) ? $tmonial_autotime : '';
        $this->include_frontslide_js('testimonial', $jsdata);
        if ($counttype == 'count') {
            return $num;
        } else {
            return $content;
        }
    }

    /**
     * Call the frontpage slider js.
     * @param string $blockid
     * @return void
     */
    public function include_frontslide_js($blockid, $data = []) {
        global $PAGE;
        $PAGE->requires->js_call_amd('theme_edifi/front-sliders', $blockid, ['data' => $data]);
    }

    /**
     * Testimonials block contents from configurations.
     * @param type|Integer $key
     * @return type|array $data.
     */
    public function get_testimonial_contents($key) {
        global $CFG, $PAGE, $OUTPUT;
        $data = array();
        if (!empty($key)) {
            $data['text'] = theme_edifi_get_setting('tmonial'. $key .'text');
            $data['uname'] = theme_edifi_get_setting('tmonial'. $key .'uname');
            $data['utype'] = theme_edifi_get_setting('tmonial'. $key .'utype');
            $imgKey = 'tmonial'.$key.'img';
            $data['imgurl'] = $PAGE->theme->setting_file_url($imgKey, $imgKey);
            if (empty($data['imgurl'])) {
                $data['imgurl'] = $OUTPUT->image_url('no-user', 'theme');
            }
        }
        return $data;
    }

    /**
     * Returns the our partners block html contents.
     * @return type
     */
    public function edifi_our_partners() {
        global $CFG, $OUTPUT, $PAGE;
        $header = $content = "";
        $partner_status = theme_edifi_get_setting('ourPartner_status');
        if ($partner_status != 0) {
            $partnerNum = theme_edifi_get_setting('ourPartner_number');
            if (empty($partnerNum)) {

                return '';

            }
            $partnerTitle = theme_edifi_get_setting('ourPartner_title');
            $partnerTitle = theme_edifi_lang($partnerTitle);
            $partnerDesc = theme_edifi_get_setting('ourPartner_desc');
            $partnerDesc = theme_edifi_lang($partnerDesc);
            $header .= html_writer::start_tag('div', array('class' => 'team-block'));
            $header .= html_writer::start_tag('div', array('class' => 'container-fluid'));
            // $span = html_writer::tag('span', '<i class="fa fa-heart"></i>');
            if (!empty($partnerTitle)) {
                $header .= html_writer::tag('h2', $partnerTitle, array('class' => 'title-headings'));
            }
            if (!empty($partnerDesc)) {
                $header .= html_writer::tag('p', $partnerDesc);
            }
            $header .= html_writer::start_tag('div', array('class' => 'our-partner'));

            if (!empty($partnerNum)) {
                $numPartner = intval($partnerNum);
                if (!empty($numPartner)) {
                    $partArr = array_combine(range(1, $numPartner), range(1, $numPartner) );
                    foreach ($partArr as $key) {
                        $data = $this->edifi_get_partner_data($key);
                       
                        if (!empty($data['imgurl']) || !empty($data['title'])) {

                            if(empty($data['imgurl'])){
                                $data['imgurl'] = $OUTPUT->image_url('no-image','theme');
                            }
                            $content .= html_writer::start_tag('div', array('class' => ''));
                            $content .= html_writer::start_tag('div', array('class' => 'img-block'));
                            if ($data['link'] != "") {
                                $content .= html_writer::start_tag('a', array('href' => $data['link']));
                            }
                            $content .= html_writer::empty_tag('img', array('src' => $data['imgurl'], 'alt' => $data['title'], 'title' => $data['title']));
                            if ($data['link'] != "") {
                                $content .= html_writer::end_tag('a');
                            }

                            $content .= html_writer::end_tag('div');
                            $content .= html_writer::end_tag('div');
                        }
                    }
                }
            }
            $footer  = html_writer::end_tag('div');
            $footer .= html_writer::end_tag('div');
            $footer .= html_writer::end_tag('div');
            $jsdata = [];
            $ourpartner_autoplay = theme_edifi_get_setting('ourPartner_autoplay');
            $ourpartner_autotime = theme_edifi_get_setting('ourPartner_autotime');
            $jsdata['ourpartner_autoplay'] = (!empty($ourpartner_autoplay)) ? true : false;
            $jsdata['ourpartner_autotime'] = (!empty($ourpartner_autotime)) ? $ourpartner_autotime : "1400";
            $this->include_frontslide_js("ourpartner", $jsdata);
            return $header.$content.$footer;
        }
    }

    /**
     * Returns the our partner blocks data.
     * @param type|integer $key
     * @return type
     */
    public function edifi_get_partner_data($key) {
        global $CFG, $PAGE, $OUTPUT;
        $partner = array();

        if (!empty($key)) {
            $titlekey = 'partner'.$key.'title';
            $title = theme_edifi_lang(theme_edifi_get_setting($titlekey));
            $partner['title'] = (!empty($title)) ? $title : "";
            $imgkey = "partner".$key.'img';
            $partner['imgurl'] = $PAGE->theme->setting_file_url($imgkey, $imgkey);
            $partner['link'] = theme_edifi_get_setting('partner'.$key.'link');
            return $partner;
        }
    }

    /**
     * Returns the marketing spots block html contents.
     * @return type
     */
    public function edifi_marketing_spots() {
        global $PAGE,$OUTPUT;
        $content = html_writer::start_tag('div', array('class' => 'site-features jarallax'));
        $content .= html_writer::start_tag('div', array('class' => 'container-fluid'));
        $content .= html_writer::start_tag('div', array('class' => 'row'));
        (int) $cs = 0;
        for ($i = 1; $i <= 4; $i++) {
            $sitestatus = theme_edifi_get_setting('sitefblock'.$i.'status');
            $sitetitle = theme_edifi_get_setting('sitefblock'.$i.'title', true);
            $blockContent = theme_edifi_get_setting('sitefblock'.$i.'content', 'format_html');
            $siteimage = $PAGE->theme->setting_file_url('sitefblock'.$i.'image', 'sitefblock'.$i.'image');
            if (!empty($sitestatus) && (!empty($sitetitle) || !empty($siteimage) || !empty($blockContent))) {
                $cs = $cs + 1;
            }
        }

        switch($cs){
            case 4:
                $class = 'col-lg-3 col-sm-6';
                break;
            case 3:
                $class = 'col-lg-4 col-sm-6';
                break;
            case 2:
                $class = 'col-md-6';
                break;
            case 1:
                $class = 'col-md-12';
                break;
            default:
                $class = 'col-lg-3 col-sm-6';
        }

        for ($i = 1; $i <= 4; $i ++) {
            $sitestatus = theme_edifi_get_setting('sitefblock'.$i.'status');
            if (!empty($sitestatus)) {
                $sitetitle = theme_edifi_get_setting('sitefblock'. $i .'title', true);
                $sitetitle = theme_edifi_lang($sitetitle);
                $sitelink = theme_edifi_get_setting('sitefblock'. $i .'link');
                $sitelink = !empty($sitelink) ? $sitelink : "javascript:void(0)";
                $blockContent = theme_edifi_get_setting('sitefblock'.$i.'content', 'format_html');
                $blockContent = theme_edifi_lang($blockContent);    
                $sitefblockimage = $PAGE->theme->setting_file_url('sitefblock'.$i.'image', 'sitefblock'.$i.'image');
                
                if (!empty($sitetitle) || !empty($blockContent) || !empty($sitefblockimage)) {
                    $content .= html_writer::start_tag('div', array('class' => $class));
                    $content .= html_writer::start_tag('div', array('class' => 'sfcol text-center'));
                    
                        if ($sitelink) {
                            $content .= html_writer::start_tag('a', array('href' => $sitelink ));
                        }
                        if (!empty($sitefblockimage)) {
                            $content .= html_writer::start_tag('div', array('class' => 'rcbox feature-0'.$i));
                            $content .= html_writer::empty_tag('img', array('src' => $sitefblockimage));
                            $content .= html_writer::end_tag('div'); // .rcbox 
                        }
                        if ($sitelink) {
                            $content .= html_writer::end_tag('a');
                        }
                        
                    if (!isset($sitelink) ) {
                        $sitelink = '#';
                    }
                    $content .= html_writer::tag('h6', html_writer::link($sitelink, $sitetitle));
                    $content .= html_writer::start_tag('div', array('class' => 'hdivider'));
                    $content .= html_writer::tag('span', '&nbsp');
                    $content .= html_writer::end_tag('div'); // .hdivider .
                    $content .= $blockContent;
                    $content .= html_writer::end_tag('div'); // .sfcol .
                    $content .= html_writer::end_tag('div'); // .col-md-3 .
                }
            }
        }
        $content .= html_writer::start_tag('div', array('class' => 'clearfix visible-sm'));
        $content .= html_writer::end_tag('div');
        $content .= html_writer::end_tag('div');
        $content .= html_writer::end_tag('div');
        $content .= html_writer::end_tag('div');
        return $content;
    }

    /**
     * Returns the counter block html contents.
     * @return type|string
     */
    public function theme_edifi_counter_block() {
        global $CFG;
        $content = '';
        $counterstatus = theme_edifi_get_setting('counterBlock');
        if ($counterstatus) {
            $blockTitle = theme_edifi_get_setting('countBlockTitle');
            $blockTitle = theme_edifi_lang($blockTitle);
            $blockDesc = theme_edifi_get_setting('countBlockDesc');
            $blockDesc = theme_edifi_lang($blockDesc);
    //       $blockImg =  theme_edifi_get_setting('counterbg_image');
            $content .= html_writer::start_tag('div', array('class' => 'counters'));
            $content .= html_writer::start_tag('div', array('class' => 'counter-block'));
        // $content .= html_writer::empty_tag('img', array('src' => '');

            $content .= html_writer::tag('div', '', array('class' => 'content-overlayer'));
            $content .= html_writer::start_tag('div', array('class' => 'container-fluid'));
            $content .= html_writer::start_tag('div', array('class' => 'counter-heading'));
            if (!empty($blockTitle))
                $content .= html_writer::tag('h2', $blockTitle, array('class' => 'title-headings'));
            if (!empty($blockDesc))
                $content .= html_writer::tag('p', $blockDesc, array('class' => 'center-alined'));
            $content .= html_writer::end_tag('div');
            $content .= html_writer::start_tag('div', array('class' => 'row'));
            $cls = 1;
            for ($i = 1; $i <= 4; $i++) {
                $value = theme_edifi_get_setting('countBlockValue'.$i);
                $value = filter_var($value, FILTER_SANITIZE_NUMBER_INT);
                if (!empty($value)) {
                    $cls++;
                }
            }
            for ($i = 1; $i <= 4; $i++) {
                $value = theme_edifi_get_setting('countBlockValue'.$i);
                $desc = theme_edifi_get_setting('countBlockContent'.$i, 'format_html');
                $desc = theme_edifi_lang($desc);
                $text = preg_split("/[0-9]+/", $value);
                $value = filter_var($value, FILTER_SANITIZE_NUMBER_INT);
                $pad = strlen($value);

                if (!empty($value)) {
                    $content .= html_writer::start_tag('div', array('class' => 'counter-element'));
                    $content .= html_writer::start_tag('div', array('class' => 'counter counter-wheel ', 'data-style' => 'wheel', 'data-max' => $value, 'data-value' => $value, 'data-pad' => $pad ));
                    $content .= html_writer::start_tag('div', array('class' => 'counter-wheel-content'));
                    $content .= html_writer::start_tag('div');
                    $content .= html_writer::tag('span', $text[0]);
                    $content .= html_writer::tag('span', '0', array('class' => 'counter-count counter-wheel-highlight') ).$text[1]."</ br>";
                    $content .= html_writer::tag('span', $desc, array('class' => 'counter-text'));
                    $content .= html_writer::end_tag('div');
                    $content .= html_writer::end_tag('div');
                    $content .= html_writer::end_tag('div');
                    $content .= html_writer::end_tag('div');
                }
            }
            $content .= html_writer::end_tag('div');
            $content .= html_writer::end_tag('div');
            $content .= html_writer::end_tag('div');
            $content .= html_writer::end_tag('div');
            // $content .= html_writer::end_tag('div');
        }
        $this->include_frontslide_js('counter');
        return $content;
    }
}


?>

