<?php
/**
 * @package    theme_edifi
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author    LMSACE Dev Team
 *
 */
 defined('MOODLE_INTERNAL') || die;

require_once($CFG->libdir.'/adminlib.php');
require_once($CFG->dirroot.'/course/externallib.php');
require_once($CFG->dirroot.'/files/externallib.php');
require_once($CFG->dirroot . '/mod/forum/lib.php');
require_once($CFG->dirroot.'/lib/filestorage/file_storage.php');
require_once $CFG->dirroot.'/mod/forum/externallib.php';

require_login(0, false);

/**
 * Class For The Edifi Demo Importer.
 */

class edifiDemoImport{

    public $config = "";
    public $categoryid = "";
    public $courseid = "";
    public $url = [];

    /**
     * Class construct function. Autocall off the functions
     * @return type
     */
    function __construct() {

        global $CFG, $PAGE;

        if ($PAGE->theme->settings->importDemo == 1) {

            $this->clear_import();
            $this->config = $this->edifi_import_json_content();
            $this->url = $this->theme_edifi_get_images();
            $this->edifi_set_frontpageloggedin();
            $categoryid = $this->edifi_demo_create_category();
            $courseid = $this->edifi_import_demo_courses($categoryid);
            $this->courseid = $courseid;
            if (!empty($this->courseid) ) {
                $this->edifi_set_featuredCourse($this->courseid);
            }
            $this->categoryid = $categoryid;
            $this->setCategoryBgimages($categoryid);
            $this->edifi_import_all_images();
            $this->edifi_load_local_images();
            $this->edifi_add_site_announcements();
        }
    }

    /**
     * Get the images fromt the demo url.
     * @return type
     */
    public function theme_edifi_get_images() {
        $images = isset($this->config['images']['general']) ? $this->config['images']['general'] : array();
        return $images;
    }

    /**
     * Get the category images.
     * @return type
     */
    public function category_images() {

        $images = isset($this->config['images']['category']) ? $this->config['images']['category'] : array();
        return $images;
    }

    /**
     * Load and set the frontpage loggedin user display blocks arrangement on moodle/
     * @return type
     */
    public function edifi_set_frontpageloggedin() {

        $value = isset($this->config['frontpage']['s__frontpageloggedin']) ? $this->config['frontpage']['s__frontpageloggedin'] : "";
        $value2 = isset($this->config['frontpage']['s__frontpage']) ? $this->config['frontpage']['s__frontpage'] : "";
        if (!empty($value)) {
            $data = array( 's__frontpageloggedin' => $value );
        }
        if (!empty($value1)) {

            $data2 = array('s__frontpage' => $value2);
            admin_write_settings($data2);

        }
        $newsitems = array('s__newsitems' => 3);
        admin_write_settings($newsitems);
    }

    /**
     * Import the json contents from the url.
     * @return type
     */
    public function edifi_import_json_content() {

        global $CFG;
        $json_url = "https://res.cloudinary.com/lmsace/raw/upload/v1593861927/edifi_data.json";
        $json = file_get_contents($json_url);
        $config = json_decode($json, true);
        array_walk_recursive($config, 'edifiDemoImport::html_decode');
        $this->config = $config;
        if (!empty($config)) {
            $this->edifi_import_general_settings();
            $this->edifi_import_homepageSlider_settings();
            $this->edifi_import_marketingspot_settings();
            $this->edifi_set_ourTeam_config();
            $this->edifi_set_testimonials_config();
            $this->edifi_set_footer_config();
            $this->edifi_counter_partner_config();
            
        }
        return $config;
    }

    /**
     * Create and load the general settings.
     * @return type
     */
    public function edifi_import_general_settings() {
        $config = $this->config;
        if (isset($config['general']) && !empty($config['general'])) {
            foreach ($config['general'] as $key => $value) {
                $this->edifi_set_config($key, $value);
            }
        }
    }
    /**
     * Load the homepage slider settings
     * @return type
     */
    public function edifi_import_homepageSlider_settings() {
        if (isset($this->config['homepage_slider']) && !empty($this->config['homepage_slider']) ) {
            $this->edifi_load_config($this->config['homepage_slider']);

        }

    }
    public function edifi_import_marketingspot_settings() {
        if (isset($this->config['marketing_spots']) && !empty($this->config['marketing_spots']) ) {
            $this->edifi_load_config($this->config['marketing_spots']);
        }
    }

    public function edifi_set_ourTeam_config() {
        if (isset($this->config['ourteam']) && !empty($this->config['ourteam']) ) {
            $this->edifi_load_config($this->config['ourteam']);
        }
    }
    public function edifi_set_testimonials_config() {
        if (isset($this->config['testimonials']) && !empty($this->config['testimonials']) ) {
            $this->edifi_load_config($this->config['testimonials']);
        }
    }
    public function edifi_set_footer_config() {
        if (isset($this->config['footer_blocks']) && !empty($this->config['footer_blocks']) ) {
            $this->edifi_load_config($this->config['footer_blocks']);
        }
    }

    public function edifi_counter_partner_config() {
        if (isset($this->config['counter_block']) && !empty($this->config['counter_block']) ) {
            $this->edifi_load_config($this->config['counter_block']);
        }
    }

    /**
     * Set the featured courses id from the demo courses id.
     * @param type|array $courseid
     * @return type
     */
    public function edifi_set_featuredCourse($courseid = array()) {
        if (!empty($courseid)) {
            $ids = array();
            foreach ($courseid as $value) {
                array_push($ids, $value['id']);
            }
            $courses = implode(',', $ids);
            $this->edifi_set_config('featured_courses', $courses);
        }
    }

    /**
     * Process all the local images with theme package.
     * @return type
     */
    public function edifi_load_local_images() {
        global $CFG;
        $localBlocks = array('logo' => 'logo.png', 'stickylogo' => 'stickylogo.png', 'footerlogo' => 'footerlogo_mwp8xm.png', 'loginbg' => 'loginbg.jpg', 'preloader' => 'loader.svg', 'counterbg_image' => 'counterbg.jpg', 'slide1' => 'slide.jpg', 'sitefblock1image' => 'sitefblock1image.png', 'sitefblock2image' => 'sitefblock2image.png', 'sitefblock3image' => 'sitefblock3image.png', 'sitefblock4image' => 'sitefblock4image.png');
        $localValues  = $this->config['images']['local'];    
        foreach ($localBlocks as $key => $value) {
            // if (!file_exists($CFG->dirroot. '/theme/edifi/pix/home/'.$value)) {
            if (isset($localValues[$key])) {
                $localBlocks[$key] = $localValues[$key];
            }
            // } else {
            // $localBlocks[$key] = $CFG->wwwroot.'/theme/edifi/pix/home/'.$value;
            // }
        }
        $this->edifi_get_local_images($localBlocks);

    }
    public function edifi_get_local_images($localBlocks = array() ) {
        if (!empty($localBlocks)) {
            foreach ($localBlocks as $key => $value) {

                $filename = basename($value);
                $hashname = get_config('theme_edifi', $key);
                $this->remove_image($key, $hashname);
                $result = $this->edifi_upload_images($key, $filename, $value);

                if (!empty($result)) {
                    $this->edifi_set_config($key, '/'.$filename);
                }
            }
           
        }
    }

    /**
     * Load all the config arrays into strings and set values with configurations
     * @param type|array $options
     * @return type
     */
    public function edifi_load_config($options = array() ) {
        if (isset($options) && !empty($options)) {
            foreach ($options as $key => $value) {
                if (is_array($value)) {
                    $this->edifi_load_config($options[$key]);
                } else {
                    $this->edifi_set_config($key, $value);
                }
            }
        }
    }

    /**
     * Create demo categories from the demo list.
     * @return array
     */
    public function edifi_demo_create_category() {
        global $CFG;
        $category = $this->edifi_demo_category_list();
        if (!empty($category)) {
            $result = core_course_external::create_categories($category);
            if (!empty($result)) {
                foreach ($result as $key => $value) {
                    $categoryid[$key] = $value['id'];
                }
            }
        }
        return $categoryid;
    }

    /**
     * Set the category background images for demo imported courses.
     * @param type|array $categoryid
     * @return type
     */
    public function setCategoryBgimages($categoryid=array()) {
        if (!empty($categoryid)) {
            foreach ($categoryid as $key => $value) { // Index => categoryid.
                $imageurl = $this->category_images();
                if (isset($imageurl["categoryimg$key"]) && !empty($imageurl["categoryimg$key"])) {
                    $name = 'category_'.$value.'.jpg';

                    $path = $this->edifi_upload_images('categoryimg'.$value, $name, $imageurl["categoryimg$key"]);
                    if (!empty($path)) {
                        $this->edifi_set_config('categoryimg'.$value, '/'.$name);
                    }
                }
            }
        }
    }

    /**
     * Set the config of moodle values.
     * @param type $key
     * @param type $value
     * @return type
     */
    protected function edifi_set_config($key, $value) {
        set_config($key, $value, 'theme_edifi');
    }

    /**
     * Upload all demo images into moodle file manager.
     * @param type $type
     * @param type $name
     * @param type $url
     * @param type $itemid
     * @return type
     */
    public function edifi_upload_images($type, $name, $url, $itemid=0) {
        $fs = get_file_storage();
        if (isset($url)) {

            $filerecord = new stdClass();
            $filerecord->component = 'theme_edifi';
            $filerecord->contextid = \context_system::instance()->id;
            $filerecord->userid    = get_admin()->id;
            $filerecord->filearea  = $type;
            $filerecord->filepath  = '/';
            $filerecord->itemid    = $itemid;
            $filerecord->filename  = $name;
            $exist = $fs->file_exists($filerecord->contextid, $filerecord->component, $filerecord->filearea, $filerecord->itemid, $filerecord->filepath, $filerecord->filename);
            if ($exist == 1) {
                $fs->delete_area_files($filerecord->contextid, $filerecord->component, $filerecord->filearea, $filerecord->itemid);
            }
            $fs->create_file_from_url($filerecord, $url);
            $url = $this->edifi_get_images($filerecord);
            

            return $url;
        }
    }

    /**
     * Import all images into moodle file managers.
     * @return null
     */
    public function edifi_import_all_images() {
        if (!empty($this->url)) {
            foreach ($this->url as $key => $value) {
                if ($value) {
                    $hashname = get_config('theme_edifi', $key);
                    $this->remove_image($key, $hashname);
                    $result = $this->edifi_upload_images($key, $key.".jpg", $value);
                    if (!empty($result)) {
                        $this->edifi_set_config($key, '/'. $key.".jpg");
                    }
                }
            }
        }
    }

    /**
     * Remove already inserted images.
     * @param type $key
     * @param type|string $hashname
     * @return type
     */
    public function remove_image($key, $hashname = "") {
        $fs = get_file_storage();
        $filerecord = new stdClass();
        $filerecord->component = 'theme_edifi';
        $filerecord->contextid = context_system::instance()->id;
        $filerecord->userid    = get_admin()->id;
        $filerecord->filearea  = $key;
        $filerecord->filepath  = '/';
        $filerecord->itemid    = 0;
        $filerecord->filename  = $hashname;
        $exist = $fs->file_exists($filerecord->contextid, $filerecord->component, $filerecord->filearea, $filerecord->itemid, $filerecord->filepath, $filerecord->filename);
        if ($exist == 1) {
            $fs->delete_area_files($filerecord->contextid, $filerecord->component, $filerecord->filearea);
        }
    }

    /**
     * Get all the image file url's from the json config value.
     * @param type|array $filerecord
     * @return type
     */
    public function edifi_get_images($filerecord = array()) {
        $fs = get_file_storage();
        if (!empty($filerecord)) {
            $files = $fs->get_area_files($filerecord->contextid, $filerecord->component, $filerecord->filearea, $filerecord->itemid, 'timemodified ASC', false);
            foreach ($files as $file) {
                $url = moodle_url::make_pluginfile_url(
                    $file->get_contextid(),
                    $file->get_component(),
                    $file->get_filearea(),
                    $file->get_itemid(),
                    $file->get_filepath(),
                    $file->get_filename()
                );
            }
        }
        return $url;
    }

    /**
     * Call and execute the site annoucement related functions.
     * @return null
     */
    public function edifi_add_site_announcements() {
        global $CFG;

        $newsList = $this->edifi_get_site_announcements();
        // print_r($newsList);
        foreach ($newsList as $key => $site) {

            $subject = $site['subject'];
            $message = $site['message'];
            $image = $site['image'];
            // echo $subject;
             $draftidattach = $this->upload_site_news_images($key, $image);
            if ($this->_edifi_create_discussion($subject, $message, $draftidattach)) {

            }

        }
    }

    /**
     * Creates the demo discussion topics in moodle frontpage site news block.
     * @param type|string $subject
     * @param type|string $message
     * @param type|string $draftidattach
     * @return type
     */
    public function _edifi_create_discussion($subject='subject', $message = '',  $draftidattach = '' ) {
        global $SITE, $CFG;
        if (empty($draftidattach)) {
            $draftidattach = file_get_unused_draft_itemid();
        }
        $newsforum = forum_get_course_forum($SITE->id, 'news');
        $forumid = $newsforum->id;
        $options = array(array('name' => 'attachmentsid', 'value' => $draftidattach));
        $createddiscussion = mod_forum_external::add_discussion($forumid, $subject, $message, -1, $options);
    }

    /**
     * Upload the site news block demo images into site news.
     * @param type|string $name
     * @param type|string $url
     * @return type
     */
    public function upload_site_news_images($name, $url) {

        global $CFG, $USER, $SITE;

        $fs = get_file_storage();
        $draftidinlineattach = file_get_unused_draft_itemid();
        $draftidattach = file_get_unused_draft_itemid();
        $edifi = new edifiDemoImport();
        $filerecord = new stdClass();
        $usercontext = context_user::instance($USER->id);
        $filerecord->component = 'user';
        $filerecord->contextid = context_user::instance($USER->id)->id;
        $filerecord->filearea  = 'draft';
        $filerecord->filepath  = '/';
        $filerecord->itemid    = $draftidattach;
        $filerecord->filename  = $name.'.jpg';
        $exist = $fs->file_exists($filerecord->contextid, $filerecord->component, $filerecord->filearea, $filerecord->itemid, $filerecord->filepath, $filerecord->filename);
        if ($exist == 1) {
            $fs->delete_area_files($filerecord->contextid, $filerecord->component, $filerecord->filearea, $filerecord->itemid);
        }

        if ($fs->create_file_from_url($filerecord, $url)) {
            return $draftidattach;
        }
    }

    /**
     * Import's all the demo courses content into moodle courses and returns the course id's list.
     * @param type|integer $categoryid
     * @return type|array
     */
    public function edifi_import_demo_courses($categoryid) {
        $courseid = array();
        $courses = $this->demo_courses_list($categoryid);
        if (!empty($courses)) {
            $result = core_course_external::create_courses($courses);
            if (!empty($result)) {
                foreach ($result as $key => $value) {
                    $courseid[$key] = $value;
                }

            }
        }
        return $courseid;
    }

    /**
     * Returns the list of demo category's content.
     * @return type|array
     */
    public function edifi_demo_category_list() {

        $category1 = array(
            'name' => 'Web Development',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );

        $category2 = array(
            'name' => 'Software Engineering',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );

        $category3 = array(
            'name' => 'IOS Development',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );

        $category4 = array(
            'name' => 'Digital Marketing',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );

        $category5 = array(
            'name' => 'Business Management',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );
        $category6 = array(
            'name' => 'Android Development',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );
        $category7 = array(
            'name' => 'IT Risk Management',
            'parent' => '0',
            'description' => 'This category is created for the dummy purpose'
        );
        $category8 = array(
            'name' => 'IT Security',
            'parent' => '0',
            'description' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor.'
        );

        $category = array($category1, $category2, $category3, $category4, $category5, $category6, $category7, $category8);
        return $category;
    }

    public function demo_courses_list($categoryid) {
        $courses = array();
        $time = time();
        $course1 = array(
            "fullname" => "Html 5",
            "shortname" => "html_5_".$time."1",
            'categoryid' => (isset($categoryid[0]) && !empty($categoryid[0]) ) ? $categoryid[0] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor. "
        );
        $course2 = array(
            "fullname" => "Software Engineering",
            "shortname" => "software-engineering_".$time."2",
            'categoryid' => (isset($categoryid[1]) && !empty($categoryid[1]) ) ? $categoryid[1] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor. "
        );
        $course3 = array(
            "fullname" => "Objective-c",
           "shortname" => "objective-c_".$time."3",
            'categoryid' => (isset($categoryid[2]) && !empty($categoryid[2])) ? $categoryid[2] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor. "
        );
        $course4 = array(
            "fullname" => "Digital Marketing",
            "shortname" => "digital-marketing_".$time."4",
            'categoryid' => (isset($categoryid[3]) && !empty($categoryid[3])) ? $categoryid[3] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor."
        );
        $course5 = array(
            "fullname" => "Business Law.",
            "shortname" => "business_law_".$time."5",
            'categoryid' => (isset($categoryid[4])&& !empty($categoryid[4])) ? $categoryid[4] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor.  "
        );
        $course6 = array(
            "fullname" => "Android",
            "shortname" => "android_".$time."6",
            'categoryid' => (isset($categoryid[5])&& !empty($categoryid[5])) ? $categoryid[5] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor. "
        );
        $course7 = array(
            "fullname" => "Risk Management",
            "shortname" => "risk_management_".$time."7",
            'categoryid' => (isset($categoryid[6])&& !empty($categoryid[6])) ? $categoryid[6] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor."
        );
        $course8 = array(
            "fullname" => "Information Security Management",
            "shortname" => "it_security_management_".$time."8",
            'categoryid' => (isset($categoryid[7])&& !empty($categoryid[7])) ? $categoryid[7] : "1",
            "summary" => "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam placerat auctor consequat. Ut quis iaculis erat, suscipit maximus tortor. "
        );
        $courses = array($course1, $course2, $course3, $course4, $course5, $course6, $course7, $course8);

        return $courses;
    }

    public function edifi_get_site_announcements() {
         $list = array(

            'sitenews1' => array('subject' => 'Dummy site news for demo 1',
                                 'message' => 'Loreum ipsum is the dolor sit ametc content for du,mmy purpose',
                                 'image' => $this->config['images']['sitenews']['sitenews1']
                                ),
            'sitenews2' => array('subject' => 'Dummy site news for demo 2',
                                 'message' => 'Loreum ipsum is the dolor sit ametc content for du,mmy purpose',
                                 'image' => $this->config['images']['sitenews']['sitenews2']
                                ),
            'sitenews3' => array('subject' => 'Dummy site news for demo 3',
                                 'message' => 'Loreum ipsum is the dolor sit ametc content for du,mmy purpose',
                                 'image' => $this->config['images']['sitenews']['sitenews3']
                                ),
            );
         return $list;
    }

    public function clear_import() {
        set_config('importDemo', '0', 'theme_edifi');
    }

    public static function html_decode(&$item, $key) {
        $item = html_entity_decode($item);
    }
}

/*$edifi = new edifiDemoImport();
$edifi->edifi_add_site_announcements();*/
?>
