define([
    'jquery',
    'theme_edifi/slick',
    'theme_edifi/jarallex',
    'theme_edifi/jquery.sudoSlider',
], function($, slick, jarallax, sudoslider) {
    'use strict';
    var RTL = ($('body').hasClass('dir-rtl')) ? true : false;
    return {
        init:function() {

        },
        availablecourses: function() {
            $(".slick_available_course").slick({

                prevArrow:'.available-courses-control .slick-prev',
                nextArrow: '.available-courses-control .slick-next',
                slidesToShow: 3,
                slidesToScroll: 3,
                infinite: false,
                arrows: true,
                rtl: RTL,
                responsive: [
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2,
                        }
                    },
                    {
                        breakpoint: 575,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                        }
                    }
                ],
            });
        },
        mycourses: function() {
            $(".slick_myenrolled_course").slick({
                prevArrow:'.mycourse-control .slick-prev',
                nextArrow: '.mycourse-control .slick-next',
                slidesToShow: 3,
                slidesToScroll: 3,
                infinite: false,
                arrows: true,
                rtl: RTL,
                responsive: [
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2,
                        }
                    },
                    {
                        breakpoint: 575,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                        }
                    }
                ],
            });
        },
        testimonial: function(data) {
            $('.tmonial-slick').slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                infinite: true,
                arrows: false,
                fade: true,
                asNavFor: '.tmonial-nav',
                rtl: RTL,
            });
            var tmonialSlick = $('.tmonial-nav').slick({
                slidesToShow: 5,
                slidesToScroll: 1,
                asNavFor: '.tmonial-slick',
                dots: false,
                centerMode: true,
                focusOnSelect: true,
                infinite: true,
                autoplay: data.tmonial_autoplay,
                autoplaySpeed: data.tmonial_autotime,
                prevArrow:'.tmonial-button .prevBtn',
                nextArrow: '.tmonial-button .nextBtn',
                rtl: RTL,
                responsive: [
                    {
                        breakpoint: 1000,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1,
                            centerMode: true,
                        }
                },
                    {
                        breakpoint: 600,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            centerMode: false,
                        }
                },
                ],
            });
            function slick_centermode() {
                var $tnav = tmonialSlick.slick('getSlick');
                var $tnavslidecount = $tnav.slideCount;
                var case1 = [{
                    breakpoint: 1000,
                    settings: { slidesToShow: 1, slidesToScroll: 1, centerMode: false }
                }, {
                    breakpoint: 600,
                    settings: { slidesToShow: 1, slidesToScroll: 1, centerMode: false }
                }];
                var case2 = [{
                    breakpoint: 1000,
                    settings: { slidesToShow: 2, slidesToScroll: 1, centerMode: false }
                }, {
                    breakpoint: 600,
                    settings: { slidesToShow: 1, slidesToScroll: 1, centerMode: false }
                }];
                var case3 = [{
                    breakpoint: 1000,
                    settings: { slidesToShow: 3, slidesToScroll: 1, centerMode: true }
                }, {
                    breakpoint: 600,
                    settings: { slidesToShow: 1, slidesToScroll: 1, centerMode: false }
                }];
                if ($tnavslidecount <= 5) {
                    switch($tnavslidecount) {
                        case 3:
                            var bp = case3;
                            break;
                        case 2:
                            var bp = case2;
                            break;
                        case 1:
                            var bp = case1;
                            break;
                        default:
                            var bp = "";
                    }
                    if (bp.length != "") {
                        tmonialSlick.slick('slickSetOption', 'responsive', bp, true);
                    }
                    if ($tnavslidecount == 5) {
                        tmonialSlick.slick('slickSetOption', 'centerMode', false, 'true');
                    } else if ($tnavslidecount < 5 && $tnavslidecount > 1 ) {
                        tmonialSlick.slick('slickSetOption', 'centerMode', true, 'true');
                    }
                    if ($tnavslidecount == 1) {
                        tmonialSlick.slick('slickSetOption', 'slidesToShow', 1, 'true');
                        tmonialSlick.slick('slickSetOption', 'centerMode', false, 'true');
                    }
                }
            }

            function addwidth() {
                if ($(window).width() <= 600 ) {
                    var fslide = $('.tmonial-nav .slick-current[data-slick-index=0]');
                    setTimeout(function(){
                        var width = Math.round(fslide.width()) + parseInt(7);
                        fslide.css({'width': width });
                    }, 100);
                }
            }
            $('.tmonial-nav').on('afterChange', function(event, slick, currentSlide, nextSlide) {
                addwidth();
            });
            addwidth();
            slick_centermode();
            $(window).resize(function() {
                slick_centermode();
                addwidth();
            });
        },
        ourpartner: function(data) {
            $(".our-partner").slick({
                dots: false,
                arrows: false,
                rtl: RTL,
                slidesToShow: 6,
                slidesToScroll: 1,
                autoplay: data.ourpartner_autoplay,
                autoplaySpeed: data.ourpartner_autotime,
                responsive: [
                {
                    breakpoint: 1124,
                    settings: {
                        slidesToShow: 4,
                        slidesToScroll: 4,
                        infinite: true,
                    }
                },
                {
                    breakpoint: 991,
                    settings: {
                        slidesToShow: 3,
                        slidesToScroll: 1,
                        infinite: true,
                    }
                },
                {
                    breakpoint: 795,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1,
                        infinite: true,
                    }
                }]
            });
            var $OP = $('.our-partner').slick('getSlick');
            var $opcount = $OP.slideCount;
            var partnerResponsive = [{
                breakpoint: 1024,
                settings: {
                    slidesToShow: $opcount,
                    slidesToScroll: 1,
                    infinite: true,
                }
            },
                {
                    breakpoint: 795,
                    settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    autoplay: true,
                    autoplaySpeed: 1000,
                }
            }];
            if ($opcount <= 5)
                $('.our-partner').slick('slickSetOption', 'slidesToShow', $opcount, true);
            if ($opcount <= 4) {
                $('.our-partner').slick('slickSetOption', 'responsive', partnerResponsive, true);
            }
        },
        counter : function(){
            $('.jarallax').jarallax();
        },
        homeslider: function(data){
            var autostopped = false;
            var sudoSlider = $('#homepage-carousel').sudoSlider({
                prevNext:true,
                prevHtml: '.homepage-carousel .prevBtn.carousel-control',
                nextHtml: '.homepage-carousel .nextBtn.carousel-control',
                continuous:true,
                speed: 1400,
                ease:'swing',
                pause: data.slideinterval,
                auto: (data.autoslideshow == "true") ? true : false,
                resumePause: data.slideinterval,
                responsive: true,
                updateBefore: true,
                useCSS:true,
                interruptible:false,
                customLink: ".homepage-carouselLink",
                initCallback:function () {
                    $('#homepage-carousel [data-slide=1]').find('.slide-text').fadeTo(1500, 1);
                    let current = $('[data-slide=1]');
                    playVideo(current);
                    setZoom(current);
                },
                afterAnimation:function (t, slider) {
                    let current = slider.find('[data-slide='+t+']');

                    setTimeout(function() {
                        current.find('.slide-text').removeClass('hide')
                    }, 150);
                    current.find('.slide-text').fadeTo(1500, 1);
                    current.prev().find('.slide-text').hide();
                    if (current.find(".video-block-container").length != "")
                        playVideo(current);
                        var youtube = current.find(".video-block-container iframe");
                    if (youtube.length != '') {
                        current.find('.slide-overlayer').trigger('click');
                        current.find(".video-block-container iframe").attr('data-state', 'play');
                    }
                    setZoom(current);
                },
                beforeAnimation:function(t, slider) {
                    $('#homepage-carousel video').hide();
                    var current = slider.find('[data-slide='+t+']');
                    current.prev().find('.slide-text').hide();
                    var $content = current.find('.slide-text > [data-animation ^= "animated"]');
                    var $class = $content.attr('class');
                    $content.each(function() {
                        var $check = $(this).attr('data-animation');
                        doAnimations($(this));
                    });
                    slider.find(current).css('z-index', '5');
                    slider.find('.slide').not(current).css('z-index', '0');
                    $('.video-slider video').show();
                }
            }).mouseenter(function() {
                var auto = sudoSlider.getValue('autoAnimation');
                if (auto) {
                    sudoSlider.stopAuto();
                } else {
                    autostopped = true;
                }
            }).mouseleave(function() {
                if (!autostopped) {
                    sudoSlider.startAuto();
                }
            });

            //var homepageSlider = $("#homepage-carousel");

            $(".homepage-carousel .prevBtn, .homepage-carousel .nextBtn, #homepage-carousel, .centeredDotsControls").hover(
                function () {
                    // Mousein
                    $(".homepage-carousel .prevBtn, .homepage-carousel .nextBtn").stop().fadeTo(200, 1);
                    $(".homepage-carousel .controls .centeredDotsControls").stop().fadeTo(200, 1);
                },
                function () {
                    //Mouse out
                    $(".homepage-carousel .prevBtn, .homepage-carousel .nextBtn").stop().fadeTo(200, 0);
                    $(".homepage-carousel .controls .centeredDotsControls").stop().fadeTo(200, 0);
                }
            );
            $(".homepage-carousel .prevBtn, .homepage-carousel .nextBtn").stop().fadeTo(0, 0);
            $(".homepage-carousel .controls .centeredDotsControls").stop().fadeTo(0, 0);

            if ("ontouchstart" in window || navigator.msMaxTouchPoints) {
                sudoSlider.setOption('touch', true);
            }
            // Mute the volume of slide video.
            $('video').each(function() {
                if ( $(this).attr('muted') == 'true' ) {
                    $(this).prop('muted', true);
                } else {
                    $(this).prop('muted', false);
                }
            });

            // Play the paused video.
            function playVideo(current) {
                $('video').stop();
                $('#homepage-carousel video').hide();
                $('#homepage-carousel video').css('z-index', '-1');
                if (current.hasClass("video-slider")) {
                    setTimeout(function() {
                        if (current.find('video').length != 0) {
                            current.find('video').get(0).play();
                            $('#homepage-carousel video').show();
                            $('#homepage-carousel video').css('z-index', '0');
                            var auto = sudoSlider.getValue('autoAnimation');
                            if (auto) {
                                sudoSlider.stopAuto();
                                var autostopped = false;
                            } else {
                                var autostopped = true;
                            }
                        }
                    }, 100 );
                } else {
                    $('.video-slider video').hide();
                }
            }

            $('video').on('ended', function() {
                var auto = autoplay;
                if (auto) {
                    sudoSlider.startAuto();
                }
            });

            // Event for clicking slide overlayer.
            $(".slide-overlayer").click(function() {
                var $this = $(this).parent(".slide-content").find('.video-block-container video');
                if ($this.length != '') {
                    var video = $this.get(0);
                    if (video.paused) {
                        video.play();
                    } else{
                        video.pause();
                    }
                }
            });

            // Set the zooming effects in slide images.
            function setZoom(current) {
                var not = current.find('img.slide-img');
                $('#homepage-carousel').find('img.slide-img').not(not).removeClass('zoom-scale');
                if (not.hasClass('zoomEffect')) {
                    not.addClass('zoom-scale');
                }
            }
            // Do animation for slide contents.
            function doAnimations(elems) {
            var animEndEv = 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend';
            elems.each(function () {
                var $this = $(this),
                    $animationType = $this.data('animation');
                // Check End of Animation and Clear the class from slide.
                $this.addClass($animationType).one(animEndEv, function () {
                    $this.removeClass($animationType);
                });
            });
            }

            // Video Controls for play and pause.
            $('video').click(function(){
            if (this.paused) {
                this.play();
            } else{
                this.pause();
            }
            })

        }
    }
});