/**
 * Template editor JavaScript for inserting placeholders into textareas.
 *
 * @module   mod_casestudy/template_editor
 * @copyright 2025 SCCA
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_casestudy/template_editor",["jquery"],(function($){var lastFocusedTextarea=null;const insertAtCursor=function(textarea,text){if(textarea){var scrollPos=textarea.scrollTop,startPos=textarea.selectionStart,endPos=textarea.selectionEnd,textBefore=textarea.value.substring(0,startPos),textAfter=textarea.value.substring(endPos,textarea.value.length);textarea.value=textBefore+text+textAfter,textarea.scrollTop=scrollPos;var newCursorPos=startPos+text.length;textarea.selectionStart=newCursorPos,textarea.selectionEnd=newCursorPos,textarea.focus(),$(textarea).trigger("change")}};return{init:function(){!function(){if($(".template-editor-form textarea").on("focus",(function(){lastFocusedTextarea=this})),!lastFocusedTextarea){var firstTextarea=$(".template-editor-form textarea").first();firstTextarea.length&&(firstTextarea.focus(),lastFocusedTextarea=firstTextarea[0])}}(),$(document).on("click",".tag-insert",(function(e){e.preventDefault();var tag=$(this).data("tag");if(tag){navigator.clipboard.writeText(tag).catch((function(){}));var targetTextarea=lastFocusedTextarea;targetTextarea||(targetTextarea=$(".template-editor-form textarea").first()[0]),targetTextarea&&insertAtCursor(targetTextarea,tag)}})),$(document).on("click",".tag-insert code",(function(e){e.preventDefault(),$(this).parent(".tag-insert").trigger("click")})),$(".tag-category h6").on("click",(function(){$(this).next("ul").slideToggle("fast"),$(this).toggleClass("collapsed")})),$(".tag-insert").css("cursor","pointer"),$(".tag-insert").attr("title",(function(){return $(this).data("tag")+" - Click or drag to insert"})),$(".tag-insert").attr("draggable","true"),$(document).on("dragstart",".tag-insert",(function(e){var tag=$(this).data("tag");tag?(e.originalEvent.dataTransfer.setData("text/plain",tag),e.originalEvent.dataTransfer.effectAllowed="copy",$(this).addClass("dragging")):e.preventDefault()})),$(document).on("dragend",".tag-insert",(function(){$(this).removeClass("dragging")})),$(".template-editor-form textarea").on("dragover",(function(e){e.preventDefault(),e.originalEvent.dataTransfer.dropEffect="copy",$(this).addClass("drag-over")})),$(".template-editor-form textarea").on("dragleave",(function(){$(this).removeClass("drag-over")})),$(".template-editor-form textarea").on("drop",(function(e){e.preventDefault(),$(this).removeClass("drag-over");var tag=e.originalEvent.dataTransfer.getData("text/plain");if(tag){var rect=this.getBoundingClientRect();e.originalEvent.clientX,rect.left,e.originalEvent.clientY,rect.top,this.focus(),insertAtCursor(this,tag)}})),$(".casestudy-submission-single").on("dragover",(function(e){e.preventDefault(),e.originalEvent.dataTransfer.dropEffect="copy",$(this).addClass("drag-over")})),$(".casestudy-submission-single").on("dragleave",(function(){$(this).removeClass("drag-over")})),$(".casestudy-submission-single").on("drop",(function(e){e.preventDefault(),$(this).removeClass("drag-over");var tag=e.originalEvent.dataTransfer.getData("text/plain");if(tag){var targetTextarea=$(this).find("textarea").first()[0];targetTextarea||(targetTextarea=lastFocusedTextarea),targetTextarea&&insertAtCursor(targetTextarea,tag)}}))}}}));

//# sourceMappingURL=template_editor.min.js.map