/**
 * A repo for the search partial in the submissions page.
 *
 * @module    mod_casestudy/submission_confirmation
 * @copyright 2025 SCCA
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_casestudy/submission_confirmation",["core/notification","core/prefetch","core/templates","core/str","core_form/changechecker"],(function(notification,Prefetch,Templates,Str,ChangeChecker){const SELECTOR_attemptSubmitButton="body.path-mod-casestudy .btn-finishsubmission",SELECTOR_attemptSubmitForm="form#frm-finishsubmission",TEMPLATES_submissionConfirmation="mod_casestudy/submission_confirmation";return{init:function(unAnsweredQuestions,requireSubmit){requireSubmit?(Prefetch.prefetchStrings("mod_casestudy",["finishandsubmit","submission_confirmation"]),Prefetch.prefetchTemplate(TEMPLATES_submissionConfirmation),(unAnsweredQuestions=>{const submitAction=document.querySelector(SELECTOR_attemptSubmitButton);submitAction&&submitAction.addEventListener("click",(async e=>{e.preventDefault();try{const content=await Templates.render(TEMPLATES_submissionConfirmation,{hasunanswered:unAnsweredQuestions>0,totalunanswered:unAnsweredQuestions});await notification.saveCancelPromise(await Str.get_string("submission_confirmation","mod_casestudy"),content,await Str.get_string("finishandsubmit","mod_casestudy"));const form=submitAction.closest(SELECTOR_attemptSubmitForm);if(!form)return;let hiddenFinish=form.querySelector('input[name="finish"]');hiddenFinish||(hiddenFinish=document.createElement("input"),hiddenFinish.type="hidden",hiddenFinish.name="finish",form.appendChild(hiddenFinish)),hiddenFinish.value=1,ChangeChecker&&"function"==typeof ChangeChecker.markFormSubmitted?ChangeChecker.markFormSubmitted(form):form.dataset.formSubmitted="true",form.submit()}catch{return}}))})(unAnsweredQuestions||0)):(()=>{const submitAction=document.querySelector(SELECTOR_attemptSubmitButton),form=document.querySelector(SELECTOR_attemptSubmitForm);submitAction&&form&&!submitAction.dataset.directBound&&(submitAction.dataset.directBound="1",submitAction.addEventListener("click",(e=>{e.preventDefault();let hiddenFinish=form.querySelector('input[name="finish"]');hiddenFinish||(hiddenFinish=document.createElement("input"),hiddenFinish.type="hidden",hiddenFinish.name="finish",form.appendChild(hiddenFinish)),hiddenFinish.value=1,ChangeChecker&&"function"==typeof ChangeChecker.markFormSubmitted?ChangeChecker.markFormSubmitted(form):form.dataset.formSubmitted="true",window.onbeforeunload=null,form.submit()})))})()}}}));

//# sourceMappingURL=submission_confirmation.min.js.map